#!/bin/bash

INSTALL_PATH=/usr/share/tibit
#INSTALL_PATH=$(pwd)

is_valid() {
	IP_TEST="$1"
	# Check if the format looks right_ (Added the two extra meta characters for better results)
	echo "$IP_TEST" | egrep -qE '^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$' || return 1
	#check that each octet is less than or equal to 255:
	echo $IP_TEST | awk -F'.' '$1 <=255 && $2 <= 255 && $3 <=255 && $4 <= 255 {print "Y" } ' | grep -q Y || return 1
	return 0
}

check_port() {
	PORT="$1"
	check=$(lsof -i -P -n | grep $PORT)
	if [ -z "$check" ];then
		 return 1
	fi
	return 0
}



get_date_from_user() {
	read -p "Enter a IP Address for Agent: " IP_ADDRESS
	while ! is_valid "$IP_ADDRESS"
	do
		read -p "Not an IP. Re-enter: " IP_ADDRESS
	done

	read -p "Enter a valid port (default:161): " PORT
	if [ -z "$PORT" ];then
		PORT=161
	fi
	check_port "$PORT"
	a=$?
	if [	$a -eq 0 ]; then
		read -p "Port $PORT is in use!\nPlease run $INSTALL_PATH/configure.sh to review the PORT choosed!"
	fi

	read -p "Enter user for SNMP v3 Authentication (default:snmp): " USERSNMP 
	if [ -z "$USERSNMP" ];then
		USERSNMP=snmp
	fi

	read -p "Enter password for SNMP v3 Authentication (default 12345678): " PASSWORD
	if [ -z "$PASSWORD" ];then 
		PASSWORD=12345678
	fi
	while [ ${#PASSWORD} -lt 8	]
	do
		read -p "Password must be more than 8 characters. Re-enter: " PASSWORD
	done
	read -p "Enter a IP Address Of MONGODB (default 127.0.0.1): " IP_MONGO
	if [ -z "$IP_MONGO" ];then
		IP_MONGO=127.0.0.1
	fi
	while ! is_valid "$IP_MONGO"
	do
		read -p "Not an IP. Re-enter: " IP_MONGO
	done

	read -p "Enter a valid port (default:27017): " PORT_MONGO
	if [ -z "$PORT_MONGO" ];then
		PORT_MONGO=27017
	fi

	IP_RANGE=$(echo $IP_ADDRESS | cut -d"." -f1-3).0/24
	echo "ip_subnet=$IP_RANGE" > $INSTALL_PATH/agent.config
	echo "ip_address=$IP_ADDRESS" >> $INSTALL_PATH/agent.config
	echo "port=$PORT"	>> $INSTALL_PATH/agent.config
	echo "user=$USERSNMP" >> $INSTALL_PATH/agent.config
	echo "pwd=$PASSWORD" >> $INSTALL_PATH/agent.config


	echo "$IP_MONGO"
cat <<EOF >>$INSTALL_PATH/mongo.config
{
    "MongoDB": {
        "auth_db": "tibit_users",
        "auth_enable": true,
        "ca_cert_path": "/etc/ssl/rootCA.pem",
        "host": "$IP_MONGO",
        "name": "tibit_pon_controller",
        "netconf_db" : "netconf_db",
        "password": "V3nk0Net",
        "port": "$PORT_MONGO",
        "tls_enable": false,
        "username": "pdmNetconf",
        "dns_srv": false,
        "db_uri": "",
        "replica_set_enable": false,
        "replica_set_name": "rs0",
        "replica_set_hosts": []
    }
}

EOF

	return 0
}

echo ""
echo "##############################"
echo "# CONFIGURE TIBIT SNMP AGENT #"
echo "##############################"

FILE=$INSTALL_PATH/agent.config
if [ -f "$FILE" ]; then
		mv $INSTALL_PATH/agent.config $INSTALL_PATH/agent.config.save
fi

FILE=$INSTALL_PATH/mongo.config
if [ -f "$FILE" ]; then
		mv $INSTALL_PATH/mongo.config $INSTALL_PATH/mongo.config.save
fi

a=$(sudo systemctl stop snmpd 2>/dev/null)
a=$(sudo systemctl disable snmpd 2>/dev/null)
a=$(sudo setcap 'cap_net_bind_service=+ep' /usr/sbin/snmpd > /dev/null)

get_date_from_user
echo ""
cat	$INSTALL_PATH/agent.config
echo ""

FILE=$INSTALL_PATH/snmp-tibit.service
echo "[Unit]" > $INSTALL_PATH/snmp-tibit.service
echo "Description=Service to Start TIBIT SNMP Agent" >> $INSTALL_PATH/snmp-tibit.service
echo "After=network.target venkovms.service" >> $INSTALL_PATH/snmp-tibit.service
echo ""	>> $INSTALL_PATH/snmp-tibit.service
echo "[Service]" >> $INSTALL_PATH/snmp-tibit.service
echo "Type=idle" >> $INSTALL_PATH/snmp-tibit.service
echo "StandardInput=tty-force" >> $INSTALL_PATH/snmp-tibit.service
echo "WorkingDirectory=$INSTALL_PATH" >> $INSTALL_PATH/snmp-tibit.service
echo "ExecStart=/bin/sh	$INSTALL_PATH/run_threading_agent.sh >/dev/null" >> $INSTALL_PATH/snmp-tibit.service
echo "Restart=always" >> $INSTALL_PATH/snmp-tibit.service
echo "TimeoutStartSec=30" >> $INSTALL_PATH/snmp-tibit.service
echo "RestartSec=300" >> $INSTALL_PATH/snmp-tibit.service
echo ""	>> $INSTALL_PATH/snmp-tibit.service
echo "[Install]" >> $INSTALL_PATH/snmp-tibit.service
echo "WantedBy=multi-user.target" >> $INSTALL_PATH/snmp-tibit.service


echo "####### WARNING ###########"
echo "# PLEASE REVIEW AGENT.CONFIG and MONGO.CONFIG in $INSTALL_PATH"
echo "# A Suggested snmp-tibit.service was created in $INSTALL_PATH"
echo "# Please review dependencies before install it!"
echo "# - To install service, just move it to /etc/systemd/system (as root or sudo)"
echo "# - To enable do the command systemctl enable snmp-tibit.service (as root or sudo)"
echo "###########################"
