#!/usr/bin/env python3
#--------------------------------------------------------------------------#
# Copyright (C) 2021 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
#--------------------------------------------------------------------------#

import sys
import json
from lxml import etree
import ncclient
from ncclient import manager
import argparse
import time
import getpass

if __name__ == '__main__':

    # Command line arguments
    parser = argparse.ArgumentParser(add_help=False,formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument(      "--help", action="help", default=argparse.SUPPRESS, help="Show this help message and exit.")
    parser.add_argument("-h", "--host", action="store", dest="host", default='127.0.0.1', required=False, help="NETCONF Server IP address or hostname.")
    parser.add_argument("-p", "--port", action="store", dest="port", default='830', required=False, help="NETCONF Server port number.")
    parser.add_argument("-o", "--onu", action="store", dest="onu", default=None, required=True, help="Onu Name or Serial.")
    parser.add_argument("-u", "--user", action="store", dest="user", default=None, required=False, help="Username.")

    parser.parse_args()
    args = parser.parse_args()

    if args.user:
    	user = args.user
    else:
    	user = getpass.getuser()

    passwd = getpass.getpass(prompt="Please enter the password for "+user+": ")
    # Connect to the Netconf Server
    with manager.connect(host=args.host, port=args.port, username=user, password=passwd, hostkey_verify=False) as conn:

        operation = 'remove'
        num_onus = 1
        # Define the body for the <edit-config> request
        ONU_CONFIG = '''
         <nc:config xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
           <tibitcntlr:onu xmlns:tibitcntlr="urn:com:tibitcom:ns:yang:controller:db">
                <tibitcntlr:onu nc:operation="{}">
                    <tibitcntlr:name>{}</tibitcntlr:name>
                    <tibitcntlr:onu>
                         <tibitcntlr:service-config>DISABLED</tibitcntlr:service-config>
                     </tibitcntlr:onu>
                </tibitcntlr:onu>
           </tibitcntlr:onu>
        </nc:config>
        '''.format(operation,args.onu)

        # Send the <edit-config> request
        print("Removing ONU " +args.onu+ " from Tibit MicroPlug database.")
        rpc_rsp = conn.edit_config(target='running', config=ONU_CONFIG).xml
        print("<rpc-reply>")
        root = etree.fromstring(bytes(rpc_rsp, encoding='utf-8'))
        print(etree.tostring(root, pretty_print=True, encoding='unicode'))

