"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

import logging

_SIMPLE_FORMAT = "%(asctime)s.%(msecs)03d %(levelname)s %(message)s"
_DATE_FORMAT = "%Y-%m-%d %H:%M:%S"
_LOG_FILENAME = "ponMgr.log"

LOGGING_FORMATTER = logging.Formatter(fmt=_SIMPLE_FORMAT, datefmt=_DATE_FORMAT)


class PonManagerLogger:
    """
    Central logger object for PON Manager API
    """

    def __init__(self):
        self._logger = logging.getLogger("ponmgr")
        self._logger.setLevel(logging.DEBUG)

        django_logger = logging.getLogger("django")
        django_logger.setLevel(logging.INFO)
        django_server_logger = logging.getLogger("django.server")
        django_server_logger.handlers = []
        django_server_logger.setLevel(logging.INFO)

        # Create console log handler
        console_handler = logging.StreamHandler()
        console_handler.setFormatter(LOGGING_FORMATTER)
        console_handler.setLevel(logging.DEBUG)
        self._logger.addHandler(console_handler)
        django_logger.addHandler(console_handler)
        django_server_logger.addHandler(console_handler)

    def add_handler(self, log_handler):
        """ Adds a new handler to the logger

        :param log_handler: the log handler to add to the logger
        """
        self._logger.addHandler(log_handler)

    def debug(self, message):
        """ Log an DEBUG level message to all active handlers for this logger """
        self._logger.debug(message)

    def info(self, message):
        """ Log an INFO level message to all active handlers for this logger """
        self._logger.info(message)

    def warning(self, message):
        """ Log an WARNING level message to all active handlers for this logger """
        self._logger.warning(message)

    def error(self, message):
        """ Log an ERROR level message to all active handlers for this logger """
        self._logger.error(message)

    def critical(self, message):
        """ Log an CRITICAL level message to all active handlers for this logger """
        self._logger.critical(message)


pon_manager_logger = PonManagerLogger()
