"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('states/<str:olt_id>/', views.OneState.as_view(), name='one_olt_state'),
    path('states/', views.States.as_view(), name='olt_states'),
    path('configs/<str:olt_id>/', views.OneConfiguration.as_view(), name='one_olt_config'),
    path('configs/', views.Configurations.as_view(), name='olt_configs'),
    path('debug/<str:olt_id>/', views.Debug.as_view(), name='olt_debug'),
    path('alarm-configs/<str:cfg_id>/', views.OneAlarmConfiguration.as_view(), name='one_olt_alarm_config'),
    path('alarm-configs/', views.AlarmConfigurations.as_view(), name='olt_alarm_configs'),
    path('alarm-histories/<str:olt_id>/', views.OneAlarmHistoryState.as_view(), name='one_olt_alarm_history'),
    path('alarm-histories/', views.AlarmHistoryStates.as_view(), name='olt_alarm_histories'),
    path('stats/<str:olt_id>/', views.Statistics.as_view(), name='one_olt_stats'),
    path('logs/<str:olt_id>/', views.Logs.as_view(), name='one_olt_logs'),
    path('automation/states/<str:olt_id>/', views.OneAutomationState.as_view(), name='one_automation_olt_state'),
    path('automation/states/', views.AutomationStates.as_view(), name='olt_automation_states'),
    path('automation/configs/Global/', views.GlobalAutomationConfig.as_view(), name='automation_global_config'),
    path('automation/configs/<str:cfg_id>/', views.OneAutomationConfig.as_view(), name='one_automation_olt_config'),
    path('automation/configs/', views.AutomationConfigs.as_view(), name='olt_automation_configs'),
    path('<str:olt_id>/disable-onu/<str:onu_id>/', views.DisableOnu.as_view(), name='olt_disable_onu'),
    path('<str:olt_id>/broadcast-enable-onus/', views.BroadcastEnableOnus.as_view(), name='olt_enable_onus'),
    path('<str:olt_id>/reset/', views.Reset.as_view(), name='olt_reset'),
    path('<str:olt_id>/allow-registration/', views.AllowRegistration.as_view(), name='olt_allow_onu_registration'),
    path('<str:olt_id>/protection-sync-olts/', views.ProtectionSyncOlts.as_view(), name='olt_protection_sync_olts'),
]
