#!/usr/bin/env bash

#check if mongo has configured.
#the file mongo-users.init is created during docker image build.
#If container has the file, the configuration of mongo is not  executed.
file=mongo-users.js
if [ -f "$file" ]; then
        echo "######## Mongo Configuration and Start"
        echo "######## Configuring Users for Authentication"
        /usr/bin/mongod --bind_ip_all  &
        lastPid=$!
        sleep 10
        mongo --quiet mongo-users.js
        sleep 10
        kill -9 $lastPid
        echo "####### Starting the replicaset"
        /usr/bin/mongod --bind_ip_all --replSet  rs0  &
        lastPid=$!
        sleep 10
        rserror=$(echo "db.getReplicationInfo()" | mongo  --quiet | grep "replication not detected" | wc -l)
        while [ "$rserror" -ne "0" ]
        do

                echo "rs.initiate()" | mongo
                sleep 10
                rserror=$(echo "db.getReplicationInfo()" | mongo  --quiet | grep "replication not detected" | wc -l)
                if [ "$rserror" -eq "0" ] ; then
                        rm $file
                        kill -9 $lastPid
                fi
        done

fi

echo "####### Starting Mongo with replicaset and authentication"
/usr/bin/mongod --bind_ip_all --replSet  rs0 --auth --keyFile /etc/ssl/mongodb-keyfile
