#!/usr/bin/env bash
#--------------------------------------------------------------------------#
# Copyright (C) 2015 - 2022 by Tibit Communications, Inc.                  #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
#--------------------------------------------------------------------------#

VERSION=R5.2.0
INITDIR=$(pwd)
PONCNTLVER=R5.2.0
NETCONFVER=R5.2.0
PONMGRVER=R5.2.0
SNMPVERSION="1.0.10"
ControllerImage=tibit-poncntl_${PONCNTLVER}_amd64.deb
ManagerImage=tibit-ponmgr_${PONMGRVER}_all.deb
NetconfImage=tibit-netconf_${NETCONFVER}_amd64.deb
SnmpImage=snmptibit-${SNMPVERSION}.deb
PLATFORM=UB2004
DATABASE_PORT=27017
LogFile=upgrade.log

exec > >( tee -a "${LogFile}" )
exec 2> >( tee -a "${LogFile}" >&2 )

if [[ $(id -u) -ne 0 ]] ; then 
    echo "Please run as root"
    exit 1
fi

echo "Checking system compatibility....."
build_os="$(lsb_release -i -s)$(lsb_release -r -s)"
if [ "${build_os}" == "Ubuntu20.04" ]; then
  echo "Compatibility check succeeded....."
elif [ "${build_os}" == "Ubuntu18.04" ]; then
  echo "This system is running \"Ubuntu18.04\" and this installation is for \"Ubuntu20.04\"."
  echo "Please download the \"Ubuntu18.04\" installation bundle: ${VERSION}-UB1804.zip"
  exit 1
else
  echo "Ubuntu version \"${build_os}\" is not supported....."
  echo "Terminating installation ....."
  exit 1
fi

#Retrieve and print MCMS Package installed versions
PonMgrVersionInstalled="Not Installed"
PonCntlVersionInstalled="Not Installed"
PonNetconfVersionInstalled="Not Installed"

PonMgrVersionInstalled="$(apt-cache policy tibit-ponmgr | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonCntlVersionInstalled="$(apt-cache policy tibit-poncntl | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonNetconfVersionInstalled="$(apt-cache policy tibit-netconf | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"

if [ -z $PonMgrVersionInstalled ] || [ $PonMgrVersionInstalled == "" ] || [ $PonMgrVersionInstalled == " " ]; then
  PonMgrVersionInstalled="Not Installed"
else
  PonMgrVersionInstalled="R$PonMgrVersionInstalled"
fi
if [ -z $PonCntlVersionInstalled ] || [ $PonCntlVersionInstalled == "" ] || [ $PonCntlVersionInstalled == " " ]; then
  PonCntlVersionInstalled="Not Installed"
else
  PonCntlVersionInstalled="R$PonCntlVersionInstalled"
fi
if [ -z $PonNetconfVersionInstalled ] || [ $PonNetconfVersionInstalled == "" ] || [ $PonNetconfVersionInstalled == " " ]; then
  PonNetconfVersionInstalled="Not Installed"
else
  PonNetconfVersionInstalled="R$PonNetconfVersionInstalled"
fi

echo "Current MCMS Component Versions:
     PON Manager: $PonMgrVersionInstalled
     PON NETCONF: $PonNetconfVersionInstalled
  PON Controller: $PonCntlVersionInstalled
"

sudo apt-get update -y && apt-get upgrade -y

# Installation of PON Controller

STATUS="$(systemctl is-active tibit-poncntl.service)"
if [ "${STATUS}" = "active" ]; then
  systemctl stop tibit-poncntl.service
fi

STATUS="$(systemctl is-active tibit-authenticator.service)"
if [ "${STATUS}" = "active" ]; then
  systemctl stop tibit-authenticator.service
fi

STATUS="$(systemctl is-active tibit-umtrelay.service)"
if [ "${STATUS}" = "active" ]; then
  systemctl stop tibit-umtrelay.service
fi


if [ -f /opt/tibit/netconf/uninstall.sh ]; then
    systemctl stop tibit-netconf.service
    cd /opt/tibit/netconf
    /opt/tibit/netconf/uninstall.sh -y || true
fi

STATUS="$(systemctl is-active tibit-netconf.service)"
if [ "${STATUS}" = "active" ]; then
    systemctl stop tibit-netconf.service
fi

if [ "${PonNetconfVersionInstalled}" != "Not Installed" ];then
    echo "
    * * * * * * * * * * * * * * * * * * * *
    Installing $NETCONFVER  MCMS Netconf
    * * * * * * * * * * * * * * * * * * * *

    $INITDIR/$NETCONFVER-Netconf-$PLATFORM/
    Executing: sudo apt-get install ./$NetconfImage -y -o Dpkg::Options::="--force-confdef"
    "
    cd $INITDIR/$NETCONFVER-Netconf-$PLATFORM/
    apt-get install ./$NetconfImage -y -o Dpkg::Options::="--force-confdef"
    cd $INITDIR
    systemctl restart tibit-netconf.service
    systemctl status --no-pager --lines 0 tibit-netconf.service
fi


if [ -f /opt/tibit/umtrelay/uninstall.sh ]; then
  echo "Uninstalling R1.2.0 UMT Relay....."
  cd /opt/tibit/umtrelay
  /opt/tibit/umtrelay/uninstall.sh -y
fi

if [ "${PonCntlVersionInstalled}" != "Not Installed" ];then
    echo "
    * * * * * * * * * * * * * * * * * * * * *
      Installing $PONCNTLVER MCMS PON Controller
    * * * * * * * * * * * * * * * * * * * * *

    $INITDIR/$PONCNTLVER-PonController-$PLATFORM/
    Executing: sudo apt-get install ./$ControllerImage -y -o Dpkg::Options::="--force-confdef"
    "
    cd $INITDIR/$PONCNTLVER-PonController-$PLATFORM/
    apt-get install ./$ControllerImage -y -o Dpkg::Options::="--force-confdef"
    cd $INITDIR
    systemctl restart tibit-poncntl.service
    systemctl status --no-pager --lines 0 tibit-poncntl.service
fi

# Installation of PON Manager

PonMgrVersion="$(apt-cache policy tibit-ponmgr | grep Installed | awk '{ print $2 }')"
if [  "${PonMgrVersion}" = "" ]; then
  STATUS="$(systemctl is-active apache2.service)"
  if [ "${STATUS}" = "active" ]; then
    systemctl stop apache2.service
  fi

  echo "

* * * * * * * * * * * * * * * * * *
  Un-installing R1.2.0 PON Manager  
* * * * * * * * * * * * * * * * * *

"

  cd $INITDIR/$PONMGRVER-PonManager/
  python3 ./legacy_uninstall.py
fi

if [ "${PonMgrVersionInstalled}" != "Not Installed" ];then
    echo "

    * * * * * * * * * * * * * * * * * * * *
      Installing $PONMGRVER MCMS PON Manager 
    * * * * * * * * * * * * * * * * * * * *

    $INITDIR/$PONMGRVER-PonManager-$PLATFORM/
    Executing: sudo apt-get install ./$ManagerImage -y
    "
    cd $INITDIR/$PONMGRVER-PonManager-$PLATFORM/
    apt-get install ./$ManagerImage -y -o Dpkg::Options::="--force-confdef"
    cd $INITDIR

  echo "Venko database files...."
  cp logos/*.png /opt/tibit/ponmgr/tibit-ponmgr/assets/images/pictures/
  cp footer/*.txt /opt/tibit/ponmgr/tibit-ponmgr/assets/text-files/
  cp databaseSeedFiles/srvConfigs/*.json /opt/tibit/ponmgr/api/databaseSeedFiles/documents/srvConfigs/
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/documents/srvConfigs/*
  cp databaseSeedFiles/firmwares/olts/* /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/olts
  cp databaseSeedFiles/firmwares/onus/* /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/onus
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/onus/*
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/olts/*
  chown www-data:www-data /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/onus/*
  chown www-data:www-data  /opt/tibit/ponmgr/api/databaseSeedFiles/firmwares/olts/*
  cp databaseSeedFiles/pictures/olts/* /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/olts/
  cp databaseSeedFiles/pictures/onus/* /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/onus/
  cp databaseSeedFiles/pictures/controllers/* /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/controllers/
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/controllers/*
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/onus/*
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/olts/*
  chown www-data:www-data  /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/controllers/*
  chown www-data:www-data /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/onus/*
  chown www-data:www-data /opt/tibit/ponmgr/api/databaseSeedFiles/pictures/olts/*
  rm /opt/tibit/ponmgr/api/databaseSeedFiles/metadata.json
  cp metadata.json /opt/tibit/ponmgr/api/databaseSeedFiles/
  chmod 644 /opt/tibit/ponmgr/api/databaseSeedFiles/metadata.json

    echo "Starting Tibit MCMS PON Manager....."
    systemctl restart apache2.service
    systemctl status --no-pager --lines 0 apache2.service
fi


RUNSNMP="$(dpkg-query -W --showformat='${Version}\n' snmp-tibit |  cut -f2- -d:)"
if [ "${RUNSNMP}" = "${SNMPVERSION}" ]; then
  echo "
  * * * * * * * * * * * * * * * * * * * *
  Upgrade Tibit SNMP is not necessary *
  * * * * * * * * * * * * * * * * * * * *"
else

    STATUS="$(systemctl is-active snmp-tibit.service)"
    if [ "${STATUS}" = "active" ]; then
        systemctl stop snmp-tibit.service
    fi

  ## VENKO Customization: Install SNMP
  echo "
   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Installing Tibit-Venko SNMP $SNMPVERSION TOOL
  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  Executing: apt-get install ./$SnmpImage -y
  "
  cd $INITDIR/$SNMPVERSION-Snmp/
  echo "$DATABASE" | sudo apt-get install -y ./$SnmpImage
  cd $INITDIR
#  cp /usr/share/tibit/snmp-tibit.service /lib/systemd/system
#  systemctl daemon-reload
#  systemctl enable snmp-tibit.service
#  systemctl start snmp-tibit.service
  ## END VENKO Customization: Install SNMP 
fi

echo "Status of Tibit Services....."
systemctl status --no-pager --lines 0 apache2.service
systemctl status --no-pager --lines 0 mongod.service
systemctl status --no-pager --lines 0 tibit-*.service
#systemctl status --no-pager --lines 0 snmp-tibit.service

echo "

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Below is a list of commands for administering the PON Controller software.

    Use the following command to start the PON Controller:

        sudo systemctl start tibit-poncntl

    Use the following command to restart the PON Controller:

        sudo systemctl restart tibit-poncntl

    Use the following command to stop the PON Controller:

        sudo systemctl stop tibit-poncntl

    Use the following command to check the status of the PON Controller:

        sudo systemctl status tibit-poncntl

    Use the following command to view log messages generated by the PON Controller process:

        sudo tail -f /var/log/tibit/ponCntl.log

    Use the following command to display the most recent console messages logged by
    the PON Controller process:

        journalctl -r -u tibit-poncntl

    Use the following command to \"tail\" console messages logged by the PON Controller
    process (similar to tail -f):

        journalctl -f -u tibit-poncntl

    Note: The systemd journaling system logs both console messages (stdout and stderr) and
    Syslog messages from PON Controller process by default. Disable either Console or Syslog
    logging in the PON Controller Configuration in MongoDB (CNTL-CFG) to avoid the duplicate
    log messages.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

"

echo
echo "Upgrade complete!"
echo

#Retrieve and print MCMS Package installed versions
PonMgrVersionInstalled="Not Installed"
PonCntlVersionInstalled="Not Installed"
PonNetconfVersionInstalled="Not Installed"

PonMgrVersionInstalled="$(apt-cache policy tibit-ponmgr | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonCntlVersionInstalled="$(apt-cache policy tibit-poncntl | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"
PonNetconfVersionInstalled="$(apt-cache policy tibit-netconf | grep Installed | awk '{ print $2 }' | awk -F: '{ print $2 }')"

if [ -z $PonMgrVersionInstalled ] || [ $PonMgrVersionInstalled == "" ] || [ $PonMgrVersionInstalled == " " ]; then
  PonMgrVersionInstalled="Not Installed"
else
  PonMgrVersionInstalled="R$PonMgrVersionInstalled"
fi
if [ -z $PonCntlVersionInstalled ] || [ $PonCntlVersionInstalled == "" ] || [ $PonCntlVersionInstalled == " " ]; then
  PonCntlVersionInstalled="Not Installed"
else
  PonCntlVersionInstalled="R$PonCntlVersionInstalled"
fi
if [ -z $PonNetconfVersionInstalled ] || [ $PonNetconfVersionInstalled == "" ] || [ $PonNetconfVersionInstalled == " " ]; then
  PonNetconfVersionInstalled="Not Installed"
else
  PonNetconfVersionInstalled="R$PonNetconfVersionInstalled"
fi

echo "MCMS Component Versions:
     PON Manager: $PonMgrVersionInstalled
     PON NETCONF: $PonNetconfVersionInstalled
  PON Controller: $PonCntlVersionInstalled
"

## VENKO Customization: Configure logrotate to hourly and size 500MB for syslogs
cp rsyslog /etc/logrotate.d/
cp /etc/cron.daily/logrotate /etc/cron.hourly/
cp logrotate.conf /etc/
## End Customization: Configure logrotate to hourly and size 500MB for syslogs

## Venko Customization: Set custom ONU default firmware download parameters and alarm configuration
echo 'Setting Venko Firmware Download Parameters...'
sed -i 's/"Backoff Divisor" : 2,/"Backoff Divisor" : 1,/g' /opt/tibit/ponmgr/api/databaseSeedFiles/documents/deviceConfigs/onus/ONU-CFG-Default.json
sed -i 's/"End Download Timeout" : 0,/"End Download Timeout" : 60,/g' /opt/tibit/ponmgr/api/databaseSeedFiles/documents/deviceConfigs/onus/ONU-CFG-Default.json

echo 'Setting Venko Default ONU Alarm Configuration...'
sed -i '191c\                "Suppress" : true' /opt/tibit/ponmgr/api/databaseSeedFiles/documents/alarmConfigs/onus/ONU-ALARM-CFG-Default.json
sed -i '187c\                "Suppress" : true' /opt/tibit/ponmgr/api/databaseSeedFiles/documents/alarmConfigs/onus/ONU-ALARM-CFG-Default.json
## End VENKO Customization: Set custom ONU default firmware download parameters and alarm configuration
