"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#

api URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  re_path(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  re_path(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Import the include() function: from django.urls import re_path, include
    3. Add a URL to urlpatterns:  re_path(r'^blog/', include(blog_urls))

    ======================================================

    Url endpoints for Django API
"""

from django.urls import re_path, path, include
from rest_framework.urlpatterns import format_suffix_patterns
from DBdjango import views

urlpatterns = [
    # API documentation endpoints
    path('docs/', include('docs.urls')),

    # PON Auto Endpoints
    path('<version>/pon_automation/', include('pon_automation.urls')),

    re_path(r'^pon_auto/tree/', views.GetPonAutoServicesForTree().as_view()),
    re_path(r'^pon_auto/state_count/', views.GetPonAutoStateCount().as_view()),
    re_path(r'^pon_auto/status/', views.GetPonAutoStatus().as_view()),

    # MGMT LAN Endpoint
    re_path(r'^mgmt_lan/tree/', views.GetMgmtLansForTree().as_view()),

    # Controller Endpoints
    path('<version>/controllers/', include('controllers.urls')),

    re_path(r'^controller/labels/', views.GetAllControllerLabels().as_view()),
    re_path(r'^controller/counts/', views.ControllerCounts().as_view()),
    re_path(r'^controller/unattached/', views.GetAllUnattachedControllers().as_view()),
    re_path(r'^controller/versions/', views.GetAllControllersWithVersions().as_view()),
    re_path(r'^controller/all/states/', views.GetAllCntlStates().as_view()),
    re_path(r'^controller/summary/(?P<mac_address>.+)/', views.GetControllerSummary().as_view()),
    re_path(r'^controller/tree/(?P<mgmt_lan>.+)/', views.GetAllCntlsForTree().as_view()),
    re_path(r'^controller/configurations/ids/', views.GetAllCntlCfgIds().as_view()),
    re_path(r'^controller/all/configurations/', views.GetAllCntlCfgs().as_view()),
    re_path(r'^controller/alarm/configuration/identifiers/', views.GetAllCntlAlarmsIds().as_view()),
    re_path(r'^controller/alarm/', views.GetAllCntlAlarms().as_view()),
    re_path(r'^controller/onu/upgrade/status/(?P<id>.+)/', views.ControllerOnuFirmwareUpgradeStatus().as_view()),
    re_path(r'^controller/auto/counts/', views.ControllerAutoCounts().as_view()),
    re_path(r'^controller/delete/(?P<mac_address>.+)/', views.DeleteController().as_view()),
    re_path(r'^controller/', views.GetCntls().as_view()),

    # Switch Endpoints
    path('<version>/switches/', include('switches.urls')),

    re_path(r'^switch/labels/', views.GetAllSwitchLabels().as_view()),
    re_path(r'^switch/controller/(?P<mac_address>.+)/', views.GetSwitchesForCntl().as_view()),
    re_path(r'^switch/region-pop/(?P<mac_address>.+)/', views.GetSwitchRegionPop().as_view()),
    re_path(r'^switch/tree/(?P<region>.+)/pops/', views.GetPopsUnderRegionForTree().as_view()),
    re_path(r'^switch/tree/(?P<region>.+)/(?P<pop>.+)/', views.GetSwitchesUnderPopForTree().as_view()),
    re_path(r'^switch/tree/regions/', views.GetSwitchRegionsForTree().as_view()),
    re_path(r'^switch/regions-pops/', views.GetAllSwitchRegionsPops().as_view()),
    re_path(r'^switch/unattached/', views.GetAllUnattachedSwitches().as_view()),
    re_path(r'^switch/versions/', views.GetAllSwitchesWithVersions().as_view()),
    re_path(r'^switch/configuration/ids/', views.SwitchCfgIds().as_view()),
    re_path(r'^switch/auto/counts/', views.SwitchAutoCounts().as_view()),
    re_path(r'^switch/delete/(?P<mac_address>.+)/', views.DeleteSwitch().as_view()),
    re_path(r'^switch/', views.GetSwitches().as_view()),

    # OLT Endpoints
    path('<version>/olts/', include('olts.urls')),

    re_path(r'^olt/firmware/first/(?P<firmware>.+)/', views.GetFirstAssignedOltFirmware().as_view()),
    re_path(r'^olt/labels/', views.GetAllOltLabels().as_view()),
    re_path(r'^olt/protection/switchover/automatic/(?P<mac_address>.+)/', views.ProtectionAutomaticSwitchover().as_view()),
    re_path(r'^olt/protection/switchover/forced/(?P<mac_address>.+)/', views.ProtectionForcedSwitchover().as_view()),
    re_path(r'^olt/protection/configuration/(?P<mac_address>.+)/', views.ProtectionCfg().as_view()),
    re_path(r'^olt/alarm/configuration/identifiers/', views.GetAllOltAlarmsIds().as_view()),
    re_path(r'^olt/switch/inventory/(?P<mac_address>.+)/', views.GetOltsInSwitchInventory().as_view()),
    re_path(r'^olt/switch/(?P<mac_address>.+)/', views.GetOltsForSwitch().as_view()),
    re_path(r'^olt/tree/switch/(?P<switch_id>.+)/', views.GetOltsUnderSwitchForTree().as_view()),
    re_path(r'^olt/tree/controller/(?P<controller_id>.+)/', views.GetOltsUnderControllerForTree().as_view()),
    re_path(r'^olt/counts/', views.OltCounts().as_view()),
    re_path(r'^olt/unattached/', views.GetAllUnattachedOlts().as_view()),
    re_path(r'^olt/pre-provisioned/', views.GetPreProvisionedOlts().as_view()),
    re_path(r'^olt/unknown/', views.GetOltsForUnknownSwitch().as_view()),
    re_path(r'^olt/versions/', views.GetAllOltsWithVersions.as_view()),
    re_path(r'^olt/state/debug/(?P<mac_address>.+)/', views.OltDebugState().as_view()),
    re_path(r'^olt/state/distinct/', views.OltDistinctIdentifiers().as_view()),
    re_path(r'^olt/controller/(?P<mac_address>.+)/', views.GetAllOltsForController().as_view()),
    re_path(r'^olt/offline/ids/', views.GetOfflineOlts().as_view()),
    re_path(r'^olt/configurations/ids/', views.GetAllOltCfgIds().as_view()),
    re_path(r'^olt/protection/peers/(?P<olt_id>.+)/', views.GetAllAvailableOltPeers().as_view()),
    re_path(r'^olt/alarm/', views.GetAllOltAlarms().as_view()),
    re_path(r'^olt/models/', views.GetOltModels().as_view()),
    re_path(r'^olt/onu/upgrade/status/(?P<id>.+)/', views.OltOnuFirmwareUpgradeStatus().as_view()),
    re_path(r'^olt/onu/automation/configs/(?P<olt_id>.+)/', views.OnuAutomationConfigsForOlt().as_view()),
    re_path(r'^olt/onu/automation/(?P<olt_id>.+)/', views.OnuAutomationStatesForOlt().as_view()),
    re_path(r'^olt/onu/configs/(?P<olt_id>.+)/', views.GetOnuConfigsUnderOlt().as_view()),
    re_path(r'^olt/onu/states/(?P<olt_id>.+)/', views.GetOnuStatesUnderOlt().as_view()),
    re_path(r'^olt/auto/counts/', views.OltAutoCounts().as_view()),
    re_path(r'^olt/delete/many/', views.DeleteManyOlts().as_view()),
    re_path(r'^olt/delete/(?P<mac_address>.+)/', views.DeleteOlt().as_view()),
    re_path(r'^olt/all/', views.GetAllOlts().as_view()),
    re_path(r'^olt/summary/(?P<mac_address>.+)/', views.GetOltSummary().as_view()),
    re_path(r'^olt/replace/(?P<old_olt_id>.+)/(?P<new_olt_id>.+)/', views.ReplaceOlt().as_view()),
    re_path(r'^olt/', views.GetOlts().as_view()),

    # ONU Endpoints
    path('<version>/onus/', include('onus.urls')),

    re_path(r'^onu/registration/allow/(?P<id>.+)/', views.OnuRegistrationAllow().as_view()),
    re_path(r'^onu/firmware/first/(?P<firmware>.+)/', views.GetFirstAssignedOnuFirmware().as_view()),
    re_path(r'^onu/labels/', views.GetAllOnuLabels().as_view()),
    re_path(r'^onu/upgrade/status/(?P<id>.+)/', views.OnuFirmwareUpgradeStatus().as_view()),
    re_path(r'^onu/state/olt/(?P<mac_address>.+)/', views.GetAllOnuStatesForOlt().as_view()),
    re_path(r'^onu/alarm/configuration/identifiers/', views.GetAllOnuAlarmsIds().as_view()),
    re_path(r'^onu/identifiers/gpon/', views.GetAllGponOnuSerialNumbers().as_view()),
    re_path(r'^onu/inventory/', views.GetOnuInventory().as_view()),
    re_path(r'^onu/counts/', views.OnuCounts().as_view()),
    re_path(r'^onu/online/controller/(?P<mac_address>.+)/', views.GetOnlineOnusForController().as_view()),
    re_path(r'^onu/unspecified/', views.GetUnspecifiedOnus().as_view()),
    re_path(r'^onu/versions/', views.GetAllOnusWithVersions().as_view()),
    re_path(r'^onu/many/mib-cur/', views.GetManyMibCurrentStates().as_view()),
    re_path(r'^onu/many/stats/', views.GetManyOnuStatistics().as_view()),
    re_path(r'^onu/distinct/stats/', views.GetManyDistinctOnuStatistics().as_view()),
    re_path(r'^onu/offline/ids/', views.GetOfflineOnus().as_view()),
    re_path(r'^onu/stat/totals/', views.GetOnuStatisticsTotals().as_view()),
    re_path(r'^onu/olt/(?P<mac_address>.+)/', views.GetOnusForOlt().as_view()),
    re_path(r'^onu/under/olt/(?P<mac_address>.+)/', views.GetOnusUnderOlt().as_view()),
    re_path(r'^onu/unattached/configs', views.GetAllUnattachedOnuConfigs().as_view()),
    re_path(r'^onu/pre-provisioned/', views.GetPreProvisionedOnus().as_view()),
    re_path(r'^onu/unattached/', views.GetAllUnattachedOnus().as_view()),
    re_path(r'^onu/sla/first/(?P<sla>.+)/', views.GetFirstAssignedOnuSla().as_view()),
    re_path(r'^onu/sla/(?P<sla>.+)/', views.GetAllSlaOnuUsage.as_view()),
    re_path(r'^onu/service/(?P<srv>.+)/', views.GetAllSrvOnuUsage.as_view()),
    re_path(r'^onu/state/distinct/', views.OnuDistinctIdentifiers().as_view()),
    re_path(r'^onu/state/epon/', views.GetEponOnus().as_view()),
    re_path(r'^onu/tree/olt/(?P<olt_id>.+)/', views.GetOnusUnderOltForTree().as_view()),
    re_path(r'^onu/configuration/ids/', views.GetAllOnuCfgIds().as_view()),
    re_path(r'^onu/alarm/', views.GetAllOnuAlarms().as_view()),
    re_path(r'^onu/auto/counts/', views.OnuAutoCounts().as_view()),
    re_path(r'^onu/vcm/counts/', views.OnuVcmCounts().as_view()),
    re_path(r'^onu/delete/many/', views.DeleteManyOnus().as_view()),
    re_path(r'^onu/(?P<mac_address>.+)/delete/all/', views.DeleteOnu().as_view()),
    re_path(r'^onu/summary/(?P<mac_address>.+)/', views.GetOnuSummary().as_view()),
    re_path(r'^onu/replace/(?P<old_onu_id>.+)/(?P<new_onu_id>.+)/', views.ReplaceOnu().as_view()),
    re_path(r'^onu/', views.GetOnus().as_view()),

    # Picture and Firmware Endpoints
    path('<version>/files/', include('files.urls')),

    re_path(r'^image/name/', views.ImageNames().as_view()),
    re_path(r'^image/logo/', views.UploadLogoImage().as_view()),

    # SLA Endpoints
    path('<version>/slas/', include('slas.urls')),

    re_path(r'^sla/configuration/identifiers/', views.GetAllSlaIds().as_view()),

    # Service Config Endpoints
    path('<version>/service-configs/', include('service_configs.urls')),

    re_path(r'^service/configuration/omci/identifiers/', views.GetAllOmciServiceIds().as_view()),
    re_path(r'^service/configuration/identifiers/', views.GetAllServiceIds().as_view()),
    re_path(r'^service/info/', views.OmciInfo().as_view()),

    # Downstream QoS Endpoints
    path('<version>/downstream-maps/', include('downstream_maps.urls')),

    re_path(r'^downstream-map/configuration/identifiers/', views.GetAllDownstreamMapIds().as_view()),

    # Database Endpoints
    path('<version>/databases/', include('databases.urls')),

    re_path(r'^database/collections/', views.CheckCollectionExistence().as_view()),
    re_path(r'^database/seed/pon/mode/', views.DatabaseSeedOltCFG().as_view()),
    re_path(r'^database/seed/', views.DatabaseSeeding().as_view()),
    re_path(r'^database/user/password/type/', views.UserDatabasePasswordType().as_view()),

    # Cascading
    path('<version>/cascading/', include('cascading.urls')),

    # CPE Endpoints
    path('<version>/cpes/', include('cpes.urls')),

    re_path(r'^cpe/state/(?P<mac_address>.+)/', views.GetCpe().as_view()),
    re_path(r'^cpe/exists/', views.CpesExist().as_view()),
    re_path(r'^cpe/onu/(?P<mac_address>.+)/', views.CpesForOnu().as_view()),  # Get All (per onu)
    re_path(r'^cpe/delete/many/(?P<mac_address>.+)/', views.DeleteManyCpes().as_view()),  # Delete many/all (per onu)

    # vCM Endpoints
    re_path(r'^vcm/onu/exist/', views.GetVcmStateExist.as_view()),  # Check if vcm collection exists
    re_path(r'^vcm/onu/(?P<mac_address>.+)/', views.GetVcmStateForOnu().as_view()),  # Get vCM State for an ONU
    # User Endpoints

    path('<version>/users/', include('users.urls')),

    re_path(r'^user/password/requirements/authenticated/', views.SetPasswordRequirements.as_view()),
    re_path(r'^user/password/requirements/unauthenticated/', views.GetPasswordRequirements.as_view()),
    re_path(r'^user/recover/validate/', views.ValidateRecoveryCode.as_view()),
    re_path(r'^user/password/reset/', views.ResetPassword.as_view()),
    re_path(r'^user/recover/email/', views.SendRecoveryEmail.as_view()),
    re_path(r'^user/session/age/all/', views.GetAllSessionAges.as_view()),
    re_path(r'^user/session/age/', views.UserSessionAgeSetting.as_view()),
    re_path(r'^user/session/all/', views.GetAllSessions.as_view()),
    re_path(r'^user/authenticate/token/', views.AuthenticateUsersToken.as_view()),
    re_path(r'^user/logout/auto/', views.AutoLogoutUser.as_view()),
    re_path(r'^user/locale/timestamp/', views.LocaleTimestampFormat.as_view()),
    re_path(r'^user/locale/location/', views.LocationPref.as_view()),
    re_path(r'^user/pon/mode', views.PonMode.as_view()),
    re_path(r'^user/log/(?P<email>.+)/(?P<since_utc_time>.+)/', views.GetSysLogsForUser.as_view()),
    re_path(r'^user/log/(?P<logId>.+)/', views.GetSysLogReturned.as_view()),
    re_path(r'^user/roles/', views.UserRoles.as_view()),
    re_path(r'^user/details/(?P<user_email>.+)/', views.UserDetails.as_view()),
    re_path(r'^user/details/', views.AdminEditUsers.as_view()),
    re_path(r'^user/auth/type/', views.UserAuthType.as_view()),
    re_path(r'^user/permissions/', views.UserPermissions.as_view()),
    re_path(r'^user/getAll/', views.GetAllUsers.as_view()),
    re_path(r'^user/exist/', views.GetUsersExist.as_view()),
    re_path(r'^user/initialize/', views.CreateInitialUser.as_view()),
    re_path(r'^user/session/', views.RefreshSession.as_view()),
    re_path(r'^user/active/', views.GetAllActiveUsers.as_view()),
    re_path(r'^user/(?P<email>.+)/', views.DeleteUser.as_view()),
    re_path(r'^user/', views.CreateUsers.as_view()),

    # Misc Endpoints
    re_path(r'^device/query/(?P<collection>.+)/(?P<attribute>.+)/(?P<operator>.+)/(?P<value>.+)/', views.CustomDeviceQuery().as_view()),
    re_path(r'^device/name/(?P<id>.+)/(?P<device_type>.+)/', views.Names().as_view()),
    re_path(r'^device/thermal/test/(?P<switch_id>.+)/', views.SwitchThermalTestData.as_view()),
    re_path(r'^device/tree/filter/(?P<device_type>.+)/', views.SearchTreeDevices.as_view()),
    re_path(r'^device/tree/filter/(?P<device_type>.+)/(?P<filter_str>.+)/', views.SearchTreeDevices.as_view()),
    re_path(r'^device/upgrade/', views.UpgradeConfigurationsToNewVersion.as_view()),
    re_path(r'^device/search/(?P<collection>.+)/', views.SearchStates.as_view()),
    re_path(r'^device/bulkchange/', views.MakeBulkChange.as_view()),
    re_path(r'^device/pictures/', views.DeviceImageNames().as_view()),
    re_path(r'^all/automation/task/', views.GetAllPonAutoEnabledTasks().as_view()),

    # PON Manager Information
    path('<version>/ponmgr/', include('ponmgr.urls')),

    # Grafana
    re_path(r'^grafana/olt/links/', views.GrafanaOltLinks.as_view()),
    re_path(r'^grafana/onu/links/', views.GrafanaOnuLinks.as_view()),

    # Search Filters
    re_path(r'^search/filters/(?P<device_type>.+)/', views.SearchFilters.as_view()),

    # Tasks
    path('<version>/tasks/', include('tasks.urls')),

    re_path(r'^task/validate/', views.GetTaskValidationStatus().as_view()),
    re_path(r'^task/detailed/states/page/(?P<task_id>.+)/', views.GetTaskDetailedStatesByPage().as_view()),

    # global PONMGR-CFG
    re_path(r'^settings/session/age/', views.GlobalSessionAgeSetting.as_view()),
    re_path(r'^settings/radius/', views.RadiusSettings.as_view()),
    re_path(r'^settings/sidenav/', views.SideNav.as_view()),
    re_path(r'^settings/', views.PonMgrSettings.as_view()),

    # DPG
    path('<version>/dpgs/', include('dpg.urls')),

    # Alarms
    re_path(r'^alarm/onu/count/', views.OnuAlarmHistoriesCount().as_view()),
    re_path(r'^alarm/onu/all/', views.AllOnuAlarmHistories().as_view()),
    re_path(r'^alarm/olt/count/', views.OltAlarmHistoriesCount().as_view()),
    re_path(r'^alarm/olt/all/', views.AllOltAlarmHistories().as_view()),
    re_path(r'^alarm/controller/count/', views.CntlAlarmHistoriesCount().as_view()),
    re_path(r'^alarm/controller/all/', views.AllCntlAlarmHistories().as_view()),
    re_path(r'^alarm/purge/bulk/', views.BulkPurgeAlarms().as_view()),
    re_path(r'^alarm/comment/bulk/', views.BulkCommentAlarms().as_view()),
    re_path(r'^alarm/acknowledge/bulk/', views.BulkAcknowledgeAlarms().as_view()),
]

urlpatterns = format_suffix_patterns(urlpatterns)
