from django.apps import apps as django_apps
from api.models import User
import hashlib
# from passlib.hash import pbkdf2_sha256

from django.conf import settings
from django.contrib.auth.hashers import make_password, check_password

from django.contrib.auth.__init__ import SESSION_KEY, BACKEND_SESSION_KEY, HASH_SESSION_KEY, \
    REDIRECT_FIELD_NAME, constant_time_compare, _get_user_session_key, _get_backends, rotate_token, user_logged_in



#Handle custom user models
from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
import mongoengine
import api.settings

class MongoBackend(object):
    def authenticate(self, request=None, **credentials):
        """
        If the given credentials are valid, return a User object.
        """
        # If radius backend, then don't attempt mongoAuth and iterate to authenticate with radius
        if 'backend' in credentials and credentials['backend'] == 'backends.radius.RADIUSBackend':
            return None

        user = User.objects.get(email=credentials['username'], database_type__ne='radius')
        if user and 'password' in user and check_password(credentials['password'], user['password']):
            user.is_active = True # Needed true for user_can_authenticate function
            #TODO: set active to false?
            return user
        else:
            return None

    def login(self, request, user, backend=None):
        """
        Persist a user id and a backend in the request. This way a user doesn't
        have to reauthenticate on every request. Note that data set during
        the anonymous session is retained when the user logs in.
        """
        session_auth_hash = ''
        if user is None:
            user = request.user
        if hasattr(user, 'get_session_auth_hash'):
            session_auth_hash = user.get_session_auth_hash()

        if SESSION_KEY in request.session:
            if _get_user_session_key(request) != user.pk or (
                    session_auth_hash and
                    not constant_time_compare(request.session.get(HASH_SESSION_KEY, ''), session_auth_hash)):
                # To avoid reusing another user's session, create a new, empty
                # session if the existing session corresponds to a different
                # authenticated user.
                request.session.flush()
        else:
            request.session.cycle_key()

        try:
            backend = backend or user.backend
        except AttributeError:
            backends = _get_backends(return_tuples=True)
            if len(backends) == 1:
                _, backend = backends[0]
            else:
                raise ValueError(
                    'You have multiple authentication backends configured and '
                    'therefore must provide the `backend` argument or set the '
                    '`backend` attribute on the user.'
                )
        else:
            if not isinstance(backend, str):
                raise TypeError('backend must be a dotted import path string (got %r).' % backend)

        request.session[SESSION_KEY] = user.uid
        request.session[BACKEND_SESSION_KEY] = backend
        request.session[HASH_SESSION_KEY] = session_auth_hash
        if hasattr(request, 'user'):
            request.user = user
        rotate_token(request)
        user_logged_in.send(sender=user.__class__, request=request, user=user)

    def logout(self, request): #TODO: May not need. Original code is running and working fine
        """
        Remove the authenticated user's ID from the request and flush their session
        data.
        """
        user = getattr(request, 'user', None)
        if not getattr(user, 'is_authenticated', True):
            user = None
        # user_logged_out.send(sender=user.__class__, request=request, user=user)

        # remember language choice saved to session
        LANGUAGE_SESSION_KEY = '_language'
        language = request.session.get(LANGUAGE_SESSION_KEY)

        request.session.flush()

        if language is not None:
            request.session[LANGUAGE_SESSION_KEY] = language

        if hasattr(request, 'user'):
            from django.contrib.auth.models import AnonymousUser
            request.user = AnonymousUser()


    def get_user_model(self):
        """
        Return the User model that is active in this project.
        """
        try:
            return django_apps.get_model(settings.AUTH_USER_MODEL, require_ready=False)
        except ValueError:
            raise ImproperlyConfigured("AUTH_USER_MODEL must be of the form 'app_label.model_name'")
        except LookupError:
            raise ImproperlyConfigured(
                "AUTH_USER_MODEL refers to model '%s' that has not been installed" % settings.AUTH_USER_MODEL
            )

    def get_user(self, user_id):
        user = None
        try:
            if user_id:
                user = User.objects.get(uid=int(user_id))
        except KeyError:
            return None
        return user if self.user_can_authenticate(user) else None

    def user_can_authenticate(self, user):
        """
        Reject users with is_active=False. Custom user models that don't have
        that attribute are allowed.
        """
        if user.backend and user.backend == 'backends.radius.RADIUSBackend':
            # Solves condition where radius user created by old djongo code can authenticate
            is_active = True
        else:
            is_active = getattr(user, 'is_active', None)
        return is_active or is_active is None