"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('states/<str:cntl_id>/', views.OneState.as_view(), name='one_cntl_state'),
    path('states/', views.States.as_view(), name='cntl_states'),
    path('configs/<str:cntl_id>/', views.OneConfiguration.as_view(), name='one_cntl_config'),
    path('configs/', views.Configurations.as_view(), name='cntl_configs'),
    path('alarm-configs/<str:cfg_id>/', views.OneAlarmConfiguration.as_view(), name='one_cntl_alarm_config'),
    path('alarm-configs/', views.AlarmConfigurations.as_view(), name='cntl_alarm_configs'),
    path('alarm-histories/<str:cntl_id>/', views.OneAlarmHistoryState.as_view(), name='one_cntl_alarm_history'),
    path('alarm-histories/', views.AlarmHistoryStates.as_view(), name='cntl_alarm_histories'),
    path('stats/<str:cntl_id>/', views.Statistics.as_view(), name='one_cntl_stats'),
    path('logs/<str:cntl_id>/', views.Logs.as_view(), name='one_cntl_logs'),
    path('automation/states/<str:cntl_id>/', views.OneAutomationState.as_view(), name='one_automation_cntl_state'),
    path('automation/states/', views.AutomationStates.as_view(), name='cntl_automation_states'),
    path('automation/configs/Global/', views.GlobalAutomationConfig.as_view(), name='automation_global_config'),
    path('automation/configs/<str:cfg_id>/', views.OneAutomationConfig.as_view(), name='one_automation_cntl_config'),
    path('automation/configs/', views.AutomationConfigs.as_view(), name='cntl_automation_configs'),
    path('auth/states/<str:cntl_id>/', views.CntlOneAuthState().as_view(), name='get_one_controller_auth_state'),
    path('auth/states/', views.CntlAuthStates().as_view(), name='get_controller_auth_states'),
    path('engine/states/<str:cntl_id>/', views.OneEngineState.as_view(), name='one_engine_state'),
    path('engine/states/', views.EngineStates.as_view(), name='engine_states'),
]
