"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path
from drf_spectacular.views import SpectacularYAMLAPIView, SpectacularAPIView, SpectacularSwaggerView, SpectacularRedocView, SpectacularJSONAPIView
# import for redoc: SpectacularRedocView
from .views import APIDocs
from api.settings import REST_FRAMEWORK

version = REST_FRAMEWORK['DEFAULT_VERSION']
urlpatterns = [
    # can make OpenAPI Document json or yml
    # path('schemaYAML/', SpectacularYAMLAPIView.as_view(), name="schema"),
    path('schema/', SpectacularYAMLAPIView.as_view(api_version=version), name="schema"),
    path('swagger/', APIDocs.as_view(), name='docs'),
]
