"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""
import json
import os

from django.utils.decorators import method_decorator
from drf_spectacular.views import SpectacularSwaggerView, SpectacularSwaggerSplitView
from rest_framework.exceptions import APIException
from utils.tools import permission_required
from django.contrib.auth.mixins import LoginRequiredMixin
from api.settings import DEBUG
from docs.json_reference_resolver import generate_swagger_schema_files, swagger_dev, PRODUCTION

from api.settings import IN_PRODUCTION

# Enable SwaggerUI schema file generation
if IN_PRODUCTION is False and PRODUCTION is False:
    swagger_dev()


# ==================================================
# ================  API Docs View ==================
# ==================================================

#  SpectacularSwaggerSplitView should be able to replace unsafe inline... error :(
class APIDocs(SpectacularSwaggerView):
    @method_decorator(permission_required('can_read_accounts_admin', raise_exception=True))
    def get(self, request):
        """ Return the swagger view """
        return super().get(request=request)



