"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

import time
from threading import Thread
from watchdog.observers import Observer
from watchdog.events import FileSystemEventHandler
from api.settings import IN_PRODUCTION, PONMGR_ETC_PATH

class FileWatcher:
    if IN_PRODUCTION:
        watch_directory = f"{PONMGR_ETC_PATH}/databases.json"
    else:
        watch_directory = "databases.json"

    def __init__(self):
        self.observer = Observer()

    def start(self, function):
        self.function = function
        thread = Thread(target=self.run, daemon=True)
        thread.start()

    def run(self):
        event_handler = Handler(self.function)
        self.observer.schedule(event_handler, self.watch_directory, recursive=True)
        self.observer.start()
        try:
            while True:
                time.sleep(1)
        except:
            self.observer.stop()
        self.observer.join()

class Handler(FileSystemEventHandler):
    def __init__(self, function):
        self.function = function

    # @staticmethod
    def on_modified(self, event):
        if event.is_directory:
            self.function()

databases_file_watcher = FileWatcher()