"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('olt-firmware/', views.OltMetadata.as_view(), name='olt_firmware_info'),
    path('onu-firmware/', views.OnuMetadata.as_view(), name='onu_firmware_info'),
    path('olt-firmware/<str:filename>/', views.OltFiles.as_view(), name='olt_firmware_files'),
    path('onu-firmware/<str:filename>/', views.OnuFiles.as_view(), name='onu_firmware_files'),
    path('pictures/', views.PictureMetadata.as_view(), name='picture_info'),
    path('pictures/<str:filename>/', views.PictureFiles.as_view(), name='picture_files'),
    path('states/', views.FilesState.as_view(), name='file_info'),
    path('states/<str:filename>/', views.OneFilesState.as_view(), name='file_states')
]
