"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views  # , private_views

urlpatterns = [
    # path('states/distinct/', views..as_view(), name='onu_state_distinct_fields'),    # PRIVATE
    path('states/<str:onu_id>/', views.OneState.as_view(), name='one_onu_state'),
    path('states/', views.States.as_view(), name='onu_states'),
    # path('configs/versions/', views.OneConfiguration.as_view(), name='onu_config_versions'),  # PRIVATE
    path('configs/<str:onu_id>/', views.OneConfiguration.as_view(), name='one_onu_config'),
    path('configs/', views.Configurations.as_view(), name='onu_configs'),
    path('alarm-configs/<str:cfg_id>/', views.OneAlarmConfiguration.as_view(), name='one_onu_alarm_config'),
    path('alarm-configs/', views.AlarmConfigurations.as_view(), name='onu_alarm_configs'),
    path('alarm-histories/<str:onu_id>/', views.OneAlarmHistoryState.as_view(), name='one_onu_alarm_history'),
    path('alarm-histories/', views.AlarmHistoryStates.as_view(), name='onu_alarm_histories'),
    path('stats/<str:onu_id>/', views.Statistics.as_view(), name='one_onu_stats'),
    # path('stats/', views..as_view(), name='onu_stats'),   # PUBLIC but not implemented/supported
    path('logs/<str:onu_id>/', views.Logs.as_view(), name='one_onu_logs'),
    # path('logs/', views..as_view(), name='onu_logs'),     # PUBLIC but not implemented/supported
    path('mib-rst/<str:onu_id>/', views.OneMibResetState.as_view(), name='one_onu_mib_rst_state'),
    path('mib-rst/', views.MibResetStates.as_view(), name='onu_mib_rst_states'),
    path('mib-cur/<str:onu_id>/', views.OneMibCurrentState.as_view(), name='one_onu_mib_cur'),
    path('mib-cur/', views.MibCurrentStates.as_view(), name='onu_mib_cur'),
    path('cpe-states/<str:onu_id>/', views.OneCpeState.as_view(), name='one_onu_cpe_state'),
    path('cpe-states/', views.CpeStates.as_view(), name='onu_cpe_states'),
    path('automation/states/<str:onu_id>/', views.OneAutomationState.as_view(), name='one_automation_onu_state'),
    path('automation/states/', views.AutomationStates.as_view(), name='onu_automation_states'),
    path('automation/configs/Global/', views.GlobalAutomationConfig.as_view(), name='automation_global_config'),
    path('automation/configs/<str:cfg_id>/', views.OneAutomationConfig.as_view(), name='one_automation_onu_config'),
    path('automation/configs/', views.AutomationConfigs.as_view(), name='onu_automation_configs'),
    path('<str:onu_id>/reset/', views.Reset.as_view(), name='onu_reset'),
    # path('upgrades/<str:onu_id>/', private_views.UpgradeStatus.as_view(), name='one_onu_upgrade'),  # PRIVATE
    # path('upgrades/', private_views.Upgrades.as_view(), name='onu_upgrades'),    # PRIVATE
    # path('serial-numbers/', private_views..as_view(), name='onu_serial_numbers'),    # PRIVATE
    # path('counts/', private_views..as_view(), name='onu_counts'),    # PRIVATE
    # path('under-controller/<str:cntl_id>/', private_views..as_view(), name='onus_under_controller'),    # PRIVATE
    # path('under-olt/<str:olt_id>/', private_views..as_view(), name='onus_under_olt'),    # PRIVATE
    # path('unattached/', private_views..as_view(), name='onus_unattached'),    # PRIVATE
    # path('using-sla/<str:sla_id>/', private_views..as_view(), name='onus_using_sla'),    # PRIVATE
    # path('using-service/<str:sla_id>/', private_views..as_view(), name='onus_using_service_config'),    # PRIVATE
    # path('hierarchy/<str:olt_id>/', private_views..as_view(), name='onu_hierarchy_for_olt'),      # PRIVATE
]
