"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('states/<str:pon_auto_id>/', views.OneState.as_view(), name='one_pon_auto_state'),
    path('states/', views.States.as_view(), name='pon_auto_states'),
    path('configs/<str:pon_auto_id>/', views.OneConfiguration.as_view(), name='one_pon_auto_config'),
    path('configs/', views.Configurations.as_view(), name='pon_auto_configs'),
    path('stats/<str:pon_auto_id>/', views.Statistics.as_view(), name='one_pon_auto_stats'),
    path('logs/<str:pon_auto_id>/', views.Logs.as_view(), name='one_pon_auto_logs')
]
