"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.contrib.auth.mixins import LoginRequiredMixin
from rest_framework.generics import GenericAPIView
from rest_framework import status
from drf_spectacular.utils import extend_schema, OpenApiParameter, OpenApiResponse

from utils.serializers import schema
from utils.schema_helpers import ResponseExample
from utils.tools import PonManagerApiResponse
import version as ponmgr_version
from utils.serializers import schema, get_schema



# ==================================================
# ========= PON Manager Version Info View ==========
# ==================================================
class Version(LoginRequiredMixin, GenericAPIView):
    raise_exception = True
    queryset = ''

    # TODO get the version number

    @extend_schema(
        operation_id="get_ponmgr_version",
        responses=None,
        tags=['version']  # 'ponmgr',
    )
    def get(self, request, version):
        """Get the version information for PON Manager"""
        res_data = {
            "Version": ponmgr_version.VERSION,
            "Build Date": ponmgr_version.BUILD_DATE,
            "Build SHA": ponmgr_version.BUILD_SHA,
            "Build OS": ponmgr_version.BUILD_OS
        }

        return PonManagerApiResponse(status=status.HTTP_200_OK, data=res_data)
