"""
#--------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# Distributed as Ciena-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('states/<str:task_id>/', views.OneTaskState.as_view(), name='one_task_state'),
    path('states/', views.TaskStates.as_view(), name='task_states'),
    path('configs/<str:task_id>/', views.OneTaskConfiguration.as_view(), name='one_task_config'),
    path('configs/', views.TaskConfigurations.as_view(), name='task_configs'),
    path('detailed/states/', views.DetailedTaskStates.as_view(), name='detailed_task_states'),
]
