#!/usr/bin/env bash
LOG_DIR=/var/log/tibit
TRACE_LOG=${LOG_DIR}/ponMgrTrace.log

# Make sure the log directory exists
if [ ! -d ${LOG_DIR} ];then
    mkdir -p ${LOG_DIR}
    chown syslog.adm ${LOG_DIR}
fi

# Make sure the ponMgrTrace.log exists
touch ${TRACE_LOG}

# User will be 'www-data' on Ubuntu and 'apache' on Red Hat
if [  id -u 'www-data' >/dev/null 2>&1 ]; then
  chown www-data.www-data ${TRACE_LOG}

elif [ id -u 'apache' >/dev/null 2>&1  ]; then
  chown apache.apache ${TRACE_LOG}

fi

chmod 644 ${TRACE_LOG}
