#!/usr/bin/env python3
# --------------------------------------------------------------------------#
# Copyright (c) 2025, Ciena Corporation                                    #
# All rights reserved.                                                     #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
# --------------------------------------------------------------------------#

# Usage: python3 generate_django_key.py

import random
import string


def generate_key(printKey=False):
    try:
        allowed_characters = string.ascii_lowercase + string.digits + '!#$%&()*+,-.:;<=>?@[]^_{}~'
        secret_key_meets_requirements = False
        while not secret_key_meets_requirements:
            secret_key = ''.join(random.SystemRandom().choice(allowed_characters) for _ in range(50))
            unique_characters = len(set(secret_key))
            if unique_characters > 10:
                if printKey:
                    print(secret_key)
                    secret_key_meets_requirements = True
                else:
                    return secret_key

    except Exception as err:
        print("WARNING: Unable to generate Django SECRET_KEY")
        print(f"Exception: {err}")
        if printKey == False:
        	return ""

if __name__ == "__main__":
	generate_key(printKey=True)
	
