#!/bin/bash

###############################################################################
# Script used to monitor the memory usage of the magma services and to log
# the memory usage into a file.
###############################################################################

source utils.sh

declare -r MEMORY_MONITOR_PATH="/var/log/venko/"
declare MEMORY_MONITOR_FILE=""

declare -r SERVICES=("enodebd" "mme" "subscriberdb" "state" "magmad" "smsd" "ctraced" "redis" "policydb" "control_proxy" "pipelined" "envoy_controller" "sessiond" "eventd" "dnsd" "mobilityd" "directoryd" "health")

# Initialize the monitoring mechanism
# Params:
#    NONE
# Returns:
#    NONE
function monitor_memory_init() {
    if [[ ! -d "${MEMORY_MONITOR_PATH}" ]]; then
        mkdir -p "${MEMORY_MONITOR_PATH}"
    fi

    MEMORY_MONITOR_FILE="venko-memory-usage-$(date +%Y-%m-%d-%H%M%S).csv"
    touch "$MEMORY_MONITOR_PATH$MEMORY_MONITOR_FILE"

    echo "${SERVICES[@]}" | tr ' ' ',' > "${MEMORY_MONITOR_PATH}${MEMORY_MONITOR_FILE}"
}

# Run the memory monitoring system
# Params:
#    NONE
# Returns:
#    NONE
function monitor_memory_run() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    local usage_data=()
    for service in "${SERVICES[@]}"; do
        memory=$(systemctl status magma@$service | grep -i "memory" | awk -F'[:()]' '{print $2}' | sed 's/^ *//;s/ *$//')
        if [[ -z "${memory}" ]]; then
            memory="N/A"
            send_notification "[$DEPLOY][$(date)] : Warn! service **$service** returned memory usage N/A"
            log_message "[$DEPLOY][$(date)] : Warn! service **$service** returned memory usage N/A" "${FUNCNAME[0]}" "$LINENO"
        fi
        usage_data+=("$memory")
    done

    echo "${usage_data[@]}" | tr '   ' ',' >> "${MEMORY_MONITOR_PATH}${MEMORY_MONITOR_FILE}"
}
