#!/bin/bash

source utils.sh
source dump-config.sh

declare -r SCTP_PATH="/proc/net/sctp"

declare SCTP_CURR_ESTAB=0
declare SCTP_PASSIVE_ESTABS=0
declare SCTP_ABORTEDS=0
declare SCTP_SHUTDOWNS=0
declare SCTP_OUTOFBLUES=0

function check_sctp_counters() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    output=$(cat "${SCTP_PATH}/snmp" | grep "SctpCurrEstab" | awk '{ print $2}')

    if [[ $output -ne $SCTP_CURR_ESTAB ]]; then
        if [[ $output -eq 1 ]]; then
            enb_ip=$(cat "${SCTP_PATH}/remaddr" | awk 'FNR==2{print $1}')
            send_notification "[$DEPLOY][$(date)] : Info! SctpCurrEstab changed from $SCTP_CURR_ESTAB to $output - eNB IP: $enb_ip"
            log_message "[$DEPLOY][$(date)] :Info! SctpCurrEstab changed from $SCTP_CURR_ESTAB to $output - eNB IP: $enb_ip" "${FUNCNAME[0]}" "$LINENO"
        elif [[ $output -eq 0 ]]; then
            send_notification "[$DEPLOY][$(date)] : Error! SctpCurrEstab changed from $SCTP_CURR_ESTAB to $output"
            log_message "[$DEPLOY][$(date)] :Error! SctpCurrEstab changed from $SCTP_CURR_ESTAB to $output" "${FUNCNAME[0]}" "$LINENO"
        fi
        SCTP_CURR_ESTAB=$output
    fi

    output=$(cat "${SCTP_PATH}/snmp" | grep "SctpPassiveEstabs" | awk '{ print $2}')
    if [[ $output -ne $SCTP_PASSIVE_ESTABS ]]; then
        send_notification "[$DEPLOY][$(date)] : Warn! SctpPassiveEstabs changed from $SCTP_PASSIVE_ESTABS to $output"
        log_message "[$DEPLOY][$(date)] : Warn! SctpPassiveEstabs changed from $SCTP_PASSIVE_ESTABS to $output" "${FUNCNAME[0]}" "$LINENO"
        SCTP_PASSIVE_ESTABS=$output
    fi

    output=$(cat "${SCTP_PATH}/snmp" | grep "SctpAborteds" | awk '{ print $2}')
    if [[ $output -ne $SCTP_ABORTEDS ]]; then
        send_notification "[$DEPLOY][$(date)] : Warn! SctpAborteds changed from $SCTP_ABORTEDS to $output"
        log_message "[$DEPLOY][$(date)] : Warn! SctpAborteds changed from $SCTP_ABORTEDS to $output" "${FUNCNAME[0]}" "$LINENO"
        SCTP_ABORTEDS=$output
    fi

    output=$(cat "${SCTP_PATH}/snmp" | grep "SctpShutdowns" | awk '{ print $2}')
    if [[ $output -ne $SCTP_SHUTDOWNS ]]; then
        send_notification "[$DEPLOY][$(date)] : Warn! SctpShutdowns changed from $SCTP_SHUTDOWNS to $output"
        log_message "[$DEPLOY][$(date)] : Warn! SctpShutdowns changed from $SCTP_SHUTDOWNS to $output" "${FUNCNAME[0]}" "$LINENO"
        SCTP_SHUTDOWNS=$output
    fi

    output=$(cat "${SCTP_PATH}/snmp" | grep "SctpOutOfBlues" | awk '{ print $2}')
    if [[ $output -ne $SCTP_OUTOFBLUES ]]; then
        send_notification "[$DEPLOY][$(date)] : Warn! SctpOutOfBlues changed from $SCTP_OUTOFBLUES to $output"
        log_message "[$DEPLOY][$(date)] : Warn! SctpOutOfBlues changed from $SCTP_OUTOFBLUES to $output" "${FUNCNAME[0]}" "$LINENO"
        SCTP_OUTOFBLUES=$output
    fi
}

function monitor_sctp_init() {
    SCTP_CURR_ESTAB=$(cat "${SCTP_PATH}/snmp" | grep "SctpCurrEstab" | awk '{ print $2}')
    SCTP_PASSIVE_ESTABS=$(cat "${SCTP_PATH}/snmp" | grep "SctpPassiveEstabs" | awk '{ print $2}')
    SCTP_ABORTEDS=$(cat "${SCTP_PATH}/snmp" | grep "SctpAborteds" | awk '{ print $2}')
    SCTP_SHUTDOWNS=$(cat "${SCTP_PATH}/snmp" | grep "SctpShutdowns" | awk '{ print $2}')
    SCTP_OUTOFBLUES=$(cat "${SCTP_PATH}/snmp" | grep "SctpOutOfBlues" | awk '{ print $2}')
}

# Function to execute the monitoring of the sctp counters
# Params:
#    $1: deploy name to be used by the logs/notifications
# Returns:
#    NONE
function monitor_sctp_run() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    while true; do
        check_sctp_counters "$DEPLOY"
        sleep 5
    done
}

