/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.aries.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.aries.transaction.jdbc.RecoverableDataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;

public class AriesPooledDataSourceFactory
implements PooledDataSourceFactory {
    protected static final String POOL_PREFIX = "pool.";

    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            DataSource ds = dsf.createDataSource(this.getNonPoolProps(props));
            RecoverableDataSource mds = new RecoverableDataSource();
            mds.setUsername(props.getProperty("user"));
            mds.setPassword(props.getProperty("password"));
            mds.setDataSource(ds);
            BeanConfig.configure((Object)mds, this.getPoolProps(props));
            mds.start();
            return mds;
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Map<String, String> getPoolProps(Properties props) {
        HashMap<String, String> poolProps = new HashMap<String, String>();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(POOL_PREFIX)) continue;
            String strippedKey = key.substring(POOL_PREFIX.length());
            poolProps.put(strippedKey, (String)props.get(key));
        }
        return poolProps;
    }

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        return dsProps;
    }
}

