/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.QName;

@Beta
public final class FormattingUtils {
    private static final CharMatcher NEWLINE_OR_TAB = CharMatcher.anyOf((CharSequence)"\n\t");
    private static final Pattern MULTIPLE_SPACES_PATTERN = Pattern.compile(" +");

    private FormattingUtils() {
        throw new UnsupportedOperationException();
    }

    public static String formatToAugmentPath(Iterable<QName> schemaPath) {
        StringBuilder sb = new StringBuilder();
        for (QName pathElement : schemaPath) {
            sb.append("\\(").append(pathElement.getNamespace()).append(')').append(pathElement.getLocalName());
        }
        return sb.toString();
    }

    public static String formatToParagraph(String text, int nextLineIndent) {
        if (Strings.isNullOrEmpty((String)text)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        String lineIndent = Strings.repeat((String)" ", (int)nextLineIndent);
        String formattedText = MULTIPLE_SPACES_PATTERN.matcher(NEWLINE_OR_TAB.replaceFrom((CharSequence)text, (CharSequence)" ")).replaceAll(" ");
        StringTokenizer tokenizer = new StringTokenizer(formattedText, " ", true);
        boolean isFirstElementOnNewLineEmptyChar = false;
        while (tokenizer.hasMoreElements()) {
            String nextElement = tokenizer.nextElement().toString();
            if (lineBuilder.length() + nextElement.length() > 80) {
                for (int i = lineBuilder.length() - 1; i >= 0 && lineBuilder.charAt(i) != ' '; --i) {
                    lineBuilder.setLength(i);
                }
                while (lineBuilder.length() > 0 && lineBuilder.charAt(0) == ' ') {
                    lineBuilder.deleteCharAt(0);
                }
                sb.append((CharSequence)lineBuilder).append('\n');
                lineBuilder.setLength(0);
                if (nextLineIndent > 0) {
                    sb.append(lineIndent);
                }
                if (" ".equals(nextElement)) {
                    isFirstElementOnNewLineEmptyChar = true;
                }
            }
            if (isFirstElementOnNewLineEmptyChar) {
                isFirstElementOnNewLineEmptyChar = false;
                continue;
            }
            lineBuilder.append(nextElement);
        }
        return sb.append((CharSequence)lineBuilder).append('\n').toString();
    }
}

