/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.util.AbstractBaseType;
import org.opendaylight.yangtools.util.LazyCollections;

final class AnnotationTypeBuilderImpl
extends AbstractBaseType
implements AnnotationTypeBuilder {
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private List<AnnotationType.Parameter> parameters = Collections.emptyList();

    AnnotationTypeBuilderImpl(JavaTypeName identifier) {
        super(identifier);
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        AnnotationTypeBuilderImpl builder;
        if (packageName != null && name != null && !this.annotationBuilders.contains(builder = new AnnotationTypeBuilderImpl(JavaTypeName.create((String)packageName, (String)name)))) {
            this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
            return builder;
        }
        return null;
    }

    private boolean addParameter(ParameterImpl param) {
        if (this.parameters.contains(param)) {
            return false;
        }
        this.parameters = LazyCollections.lazyAdd(this.parameters, (Object)param);
        return true;
    }

    public boolean addParameter(String paramName, String value) {
        if (paramName != null && value != null) {
            ParameterImpl param = new ParameterImpl(paramName, value);
            return this.addParameter(param);
        }
        return false;
    }

    public boolean addParameters(String paramName, List<String> values) {
        if (paramName != null && values != null) {
            ParameterImpl param = new ParameterImpl(paramName, values);
            return this.addParameter(param);
        }
        return false;
    }

    public AnnotationType build() {
        return new AnnotationTypeImpl(this.getIdentifier(), this.annotationBuilders, this.parameters);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getIdentifier().equals((Object)((AnnotationTypeBuilderImpl)obj).getIdentifier());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotationTypeBuilder [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", annotationBuilders=");
        builder.append(this.annotationBuilders);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append("]");
        return builder.toString();
    }

    private static final class ParameterImpl
    implements AnnotationType.Parameter {
        private final String name;
        private final String value;
        private final List<String> values;

        ParameterImpl(String name, String value) {
            this.name = name;
            this.value = value;
            this.values = Collections.emptyList();
        }

        ParameterImpl(String name, List<String> values) {
            this.name = name;
            this.values = values;
            this.value = null;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterImpl other = (ParameterImpl)obj;
            return Objects.equals(this.name, other.name);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ParameterImpl [name=");
            builder.append(this.name);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class AnnotationTypeImpl
    implements AnnotationType {
        private final JavaTypeName identifier;
        private final List<AnnotationType> annotations;
        private final List<AnnotationType.Parameter> parameters;
        private final List<String> paramNames;

        AnnotationTypeImpl(JavaTypeName identifier, List<AnnotationTypeBuilder> annotationBuilders, List<AnnotationType.Parameter> parameters) {
            this.identifier = Objects.requireNonNull(identifier);
            ArrayList<AnnotationType> a = new ArrayList<AnnotationType>();
            for (AnnotationTypeBuilder builder : annotationBuilders) {
                a.add(builder.build());
            }
            this.annotations = ImmutableList.copyOf(a);
            ArrayList<String> p = new ArrayList<String>();
            for (AnnotationType.Parameter parameter : parameters) {
                p.add(parameter.getName());
            }
            this.paramNames = ImmutableList.copyOf(p);
            this.parameters = parameters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(parameters);
        }

        public JavaTypeName getIdentifier() {
            return this.identifier;
        }

        public List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        public AnnotationType.Parameter getParameter(String paramName) {
            if (paramName != null) {
                for (AnnotationType.Parameter parameter : this.parameters) {
                    if (!parameter.getName().equals(paramName)) continue;
                    return parameter;
                }
            }
            return null;
        }

        public List<AnnotationType.Parameter> getParameters() {
            return this.parameters;
        }

        public List<String> getParameterNames() {
            return this.paramNames;
        }

        public boolean containsParameters() {
            return !this.parameters.isEmpty();
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationTypeImpl other = (AnnotationTypeImpl)obj;
            return this.identifier.equals((Object)other.identifier);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AnnotationType [packageName=");
            builder.append(this.getPackageName());
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", annotations=");
            builder.append(this.annotations);
            builder.append(", parameters=");
            builder.append(this.parameters);
            builder.append("]");
            return builder.toString();
        }
    }
}

