/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractTypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.MethodParameterImpl;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.MethodSignatureImpl;
import org.opendaylight.yangtools.util.LazyCollections;

final class MethodSignatureBuilderImpl
extends AbstractTypeMemberBuilder<MethodSignatureBuilder>
implements MethodSignatureBuilder {
    private List<MethodSignature.Parameter> parameters = Collections.emptyList();
    private List<MethodSignature.Parameter> unmodifiableParams = Collections.emptyList();
    private boolean isAbstract;
    private boolean isDefault;

    MethodSignatureBuilderImpl(String name) {
        super(name);
    }

    public MethodSignatureBuilder setAbstract(boolean newIsAbstract) {
        this.isAbstract = newIsAbstract;
        return this;
    }

    public MethodSignatureBuilder setDefault(boolean newIsDefault) {
        this.isDefault = newIsDefault;
        return this;
    }

    public MethodSignatureBuilder addParameter(Type type, String name) {
        this.parameters = LazyCollections.lazyAdd(this.parameters, (Object)new MethodParameterImpl(name, type));
        this.unmodifiableParams = Collections.unmodifiableList(this.parameters);
        return this;
    }

    @Override
    protected MethodSignatureBuilder thisInstance() {
        return this;
    }

    public MethodSignature toInstance(Type definingType) {
        List<AnnotationType> annotations = this.toAnnotationTypes();
        return new MethodSignatureImpl(definingType, this.getName(), annotations, this.getComment(), this.getAccessModifier(), this.getReturnType(), this.unmodifiableParams, this.isFinal(), this.isAbstract, this.isStatic(), this.isDefault);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.getReturnType());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureBuilderImpl other = (MethodSignatureBuilderImpl)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        return Objects.equals(this.getReturnType(), other.getReturnType());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodSignatureBuilderImpl [name=");
        builder.append(this.getName());
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", annotationBuilders=");
        builder.append(this.getAnnotationBuilders());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append("]");
        return builder.toString();
    }
}

