/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractTypeMember;

class MethodSignatureImpl
extends AbstractTypeMember
implements MethodSignature {
    private final List<MethodSignature.Parameter> params;
    private final boolean isAbstract;
    private final boolean isDefault;

    MethodSignatureImpl(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic) {
        this(definingType, name, annotations, comment, accessModifier, returnType, params, isFinal, isAbstract, isStatic, false);
    }

    MethodSignatureImpl(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic, boolean isDefault) {
        super(definingType, name, annotations, comment, accessModifier, returnType, isFinal, isStatic);
        this.params = params;
        this.isAbstract = isAbstract;
        this.isDefault = isDefault;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<MethodSignature.Parameter> getParameters() {
        return this.params;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Objects.hashCode(this.getReturnType());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureImpl other = (MethodSignatureImpl)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.params, other.params)) {
            return false;
        }
        return Objects.equals(this.getReturnType(), other.getReturnType());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodSignatureImpl [name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        if (this.getDefiningType() != null) {
            builder.append(", definingType=");
            builder.append(this.getDefiningType().getPackageName());
            builder.append(".");
            builder.append(this.getDefiningType().getName());
        } else {
            builder.append(", definingType= null");
        }
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", params=");
        builder.append(this.params);
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append("]");
        return builder.toString();
    }
}

