/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.OspfLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.ospf.topology.rev131021.ospf.link.attributes.ospf.link.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OspfLinkAttributesBuilder
implements Builder<OspfLinkAttributes> {
    private Short _multiTopologyId;
    private Ted _ted;
    Map<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>> augmentation = Collections.emptyMap();

    public OspfLinkAttributesBuilder() {
    }

    public OspfLinkAttributesBuilder(OspfLinkAttributes base) {
        Map aug;
        this._multiTopologyId = base.getMultiTopologyId();
        this._ted = base.getTed();
        if (base instanceof OspfLinkAttributesImpl) {
            OspfLinkAttributesImpl impl = (OspfLinkAttributesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>>(aug);
        }
    }

    public Short getMultiTopologyId() {
        return this._multiTopologyId;
    }

    public Ted getTed() {
        return this._ted;
    }

    public <E$$ extends Augmentation<OspfLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMultiTopologyIdRange(short value) {
        if (value >= 0 && value <= 127) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..127]]", (int)value);
    }

    public OspfLinkAttributesBuilder setMultiTopologyId(Short value) {
        if (value != null) {
            OspfLinkAttributesBuilder.checkMultiTopologyIdRange(value);
        }
        this._multiTopologyId = value;
        return this;
    }

    public OspfLinkAttributesBuilder setTed(Ted value) {
        this._ted = value;
        return this;
    }

    public OspfLinkAttributesBuilder addAugmentation(Class<? extends Augmentation<OspfLinkAttributes>> augmentationType, Augmentation<OspfLinkAttributes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OspfLinkAttributesBuilder removeAugmentation(Class<? extends Augmentation<OspfLinkAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OspfLinkAttributes build() {
        return new OspfLinkAttributesImpl(this);
    }

    private static final class OspfLinkAttributesImpl
    implements OspfLinkAttributes {
        private final Short _multiTopologyId;
        private final Ted _ted;
        private Map<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        OspfLinkAttributesImpl(OspfLinkAttributesBuilder base) {
            this._multiTopologyId = base.getMultiTopologyId();
            this._ted = base.getTed();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OspfLinkAttributes> getImplementedInterface() {
            return OspfLinkAttributes.class;
        }

        @Override
        public Short getMultiTopologyId() {
            return this._multiTopologyId;
        }

        @Override
        public Ted getTed() {
            return this._ted;
        }

        public <E$$ extends Augmentation<OspfLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._multiTopologyId);
            result = 31 * result + Objects.hashCode(this._ted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OspfLinkAttributes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OspfLinkAttributes other = (OspfLinkAttributes)obj;
            if (!Objects.equals(this._multiTopologyId, other.getMultiTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._ted, other.getTed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OspfLinkAttributesImpl otherImpl = (OspfLinkAttributesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OspfLinkAttributes>>, Augmentation<OspfLinkAttributes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OspfLinkAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_multiTopologyId", (Object)this._multiTopologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ted", (Object)this._ted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

