/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Objects;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.netconf.console.api.NetconfCommands;
import org.opendaylight.netconf.console.commands.NetconfCommandUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.ProtocolBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.specification.TlsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.specification.TlsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.protocol.specification.tls._case.TlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPasswordBuilder;

@Service
@Command(name="connect-device", scope="netconf", description="Connect to a netconf device.")
public class NetconfConnectDeviceCommand
implements Action {
    @Reference
    private NetconfCommands service;
    @Option(name="-i", aliases={"--ipaddress"}, description="IP address of the netconf device", required=true, multiValued=false)
    private String deviceIp;
    @Option(name="-p", aliases={"--port"}, description="Port of the netconf device", required=true, multiValued=false)
    private String devicePort;
    @Option(name="-U", aliases={"--username"}, description="Username for netconf connection", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="Password for netconf connection", required=false, multiValued=false)
    private String password;
    @Option(name="-t", aliases={"--tcp-only"}, description="Type of connection, true for tcp only", required=false, multiValued=false)
    private String connectionType = "false";
    @Option(name="-pr", aliases={"--protocol"}, description="Which protocol to be used, ssh or tls", required=false, multiValued=false)
    private String protocol = "ssh";
    @Option(name="-ev", aliases={"--excluded-versions"}, description="TLS versions not supported by target device", required=false, multiValued=false)
    private String excludedTlsVersions;
    @Option(name="-sl", aliases={"--schemaless"}, description="Schemaless surpport, true for schemaless", required=false, multiValued=false)
    private String schemaless = "false";
    @Option(name="-id", aliases={"--identifier"}, description="Node Identifier of the netconf device", required=false, multiValued=false)
    private String deviceId;

    public NetconfConnectDeviceCommand() {
    }

    @VisibleForTesting
    NetconfConnectDeviceCommand(NetconfCommands service) {
        this.service = service;
    }

    @VisibleForTesting
    NetconfConnectDeviceCommand(NetconfCommands service, String deviceIp, String devicePort, String username, String password) {
        this.service = Objects.requireNonNull(service);
        this.deviceIp = Objects.requireNonNull(deviceIp);
        this.devicePort = Objects.requireNonNull(devicePort);
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    public Object execute() {
        if (!NetconfCommandUtils.isIpValid(this.deviceIp) || !NetconfCommandUtils.isPortValid(this.devicePort)) {
            return "Invalid IP:" + this.deviceIp + " or Port:" + this.devicePort + "Please enter a valid entry to proceed.";
        }
        boolean isTcpOnly = this.connectionType.equals("true");
        boolean isSchemaless = this.schemaless.equals("true");
        NetconfNodeBuilder netconfNodeBuilder = new NetconfNodeBuilder();
        netconfNodeBuilder.setHost(new Host(new IpAddress(new Ipv4Address(this.deviceIp)))).setPort(new PortNumber(Integer.decode(this.devicePort))).setTcpOnly(Boolean.valueOf(isTcpOnly)).setSchemaless(Boolean.valueOf(isSchemaless));
        if (isTcpOnly || this.protocol.equalsIgnoreCase("ssh")) {
            if (Strings.isNullOrEmpty((String)this.username) || Strings.isNullOrEmpty((String)this.password)) {
                return "Empty Username:" + this.username + " or Password:" + this.password + ". In TCP or SSH mode, you must provide valid username and password.";
            }
            LoginPassword credentials = new LoginPasswordBuilder().setPassword(this.password).setUsername(this.username).build();
            netconfNodeBuilder.setCredentials((Credentials)credentials);
            if (!isTcpOnly) {
                netconfNodeBuilder.setProtocol(new ProtocolBuilder().setName(Protocol.Name.SSH).build());
            }
        } else if (this.protocol.equalsIgnoreCase("tls")) {
            TlsCase tlsCase = null;
            if (!Strings.isNullOrEmpty((String)this.excludedTlsVersions)) {
                tlsCase = new TlsCaseBuilder().setTls(new TlsBuilder().setExcludedVersions(Arrays.asList(this.excludedTlsVersions.split(","))).build()).build();
            }
            netconfNodeBuilder.setProtocol(new ProtocolBuilder().setName(Protocol.Name.TLS).setSpecification(tlsCase).build());
        } else {
            return "Invalid protocol: " + this.protocol + ". Only SSH and TLS are supported.";
        }
        this.service.connectDevice(netconfNodeBuilder.build(), this.deviceId);
        String message = "Netconf connector added succesfully";
        return "Netconf connector added succesfully";
    }
}

