/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.netconf.console.api.NetconfCommands;
import org.opendaylight.netconf.console.commands.NetconfCommandUtils;

@Service
@Command(name="disconnect-device", scope="netconf", description="Disconnect netconf device.")
public class NetconfDisconnectDeviceCommand
implements Action {
    @Reference
    private NetconfCommands service;
    @Option(name="-i", aliases={"--ipaddress"}, description="IP address of the netconf device", required=false, multiValued=false)
    private String deviceIp;
    @Option(name="-p", aliases={"--port"}, description="Port of the netconf device", required=false, multiValued=false)
    private String devicePort;
    @Option(name="-id", aliases={"--identifier"}, description="Node Identifier of the netconf device", required=false, multiValued=false)
    private String deviceId;

    public NetconfDisconnectDeviceCommand() {
    }

    @VisibleForTesting
    NetconfDisconnectDeviceCommand(NetconfCommands service) {
        this.service = service;
    }

    @VisibleForTesting
    NetconfDisconnectDeviceCommand(NetconfCommands service, String deviceId, String deviceIp, String devicePort) {
        this.service = service;
        this.deviceId = deviceId;
        this.deviceIp = deviceIp;
        this.devicePort = devicePort;
    }

    public Object execute() {
        boolean status = false;
        if (!Strings.isNullOrEmpty((String)this.deviceId)) {
            status = this.service.disconnectDevice(this.deviceId);
        } else {
            if (!NetconfCommandUtils.isIpValid(this.deviceIp) || !NetconfCommandUtils.isPortValid(this.devicePort)) {
                return "Invalid IP:" + this.deviceIp + " or Port:" + this.devicePort + "Please enter a valid entry to proceed.";
            }
            status = this.service.disconnectDevice(this.deviceIp, this.devicePort);
        }
        String message = status ? "Netconf connector disconnected succesfully" : "Failed to disconnect netconf connector. Refer to karaf.log for details.";
        return message;
    }
}

