/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.utils;

import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.console.utils.NetconfIidFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfConsoleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConsoleUtils.class);

    private NetconfConsoleUtils() {
        throw new IllegalStateException("Instantiating utility class.");
    }

    public static List<Node> getNetconfNodeFromIp(String deviceIp, DataBroker db) {
        Topology topology = NetconfConsoleUtils.read(LogicalDatastoreType.OPERATIONAL, NetconfIidFactory.NETCONF_TOPOLOGY_IID, db);
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (NetconfConsoleUtils.isNetconfNodesPresent(topology)) {
            for (Node node : topology.getNode()) {
                NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
                if (netconfNode == null || !netconfNode.getHost().getIpAddress().getIpv4Address().getValue().equals(deviceIp)) continue;
                nodes.add(node);
            }
        }
        return nodes.isEmpty() ? null : nodes;
    }

    public static List<Node> getNetconfNodeFromId(String nodeId, DataBroker db) {
        Node node = NetconfConsoleUtils.read(LogicalDatastoreType.OPERATIONAL, NetconfIidFactory.netconfNodeIid(nodeId), db);
        if (node != null) {
            return Arrays.asList(node);
        }
        return null;
    }

    public static Node getNetconfNodeFromIpAndPort(String deviceIp, String devicePort, DataBroker db) {
        Topology topology = NetconfConsoleUtils.read(LogicalDatastoreType.OPERATIONAL, NetconfIidFactory.NETCONF_TOPOLOGY_IID, db);
        if (NetconfConsoleUtils.isNetconfNodesPresent(topology)) {
            for (Node node : topology.getNode()) {
                NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
                if (netconfNode == null || !netconfNode.getHost().getIpAddress().getIpv4Address().getValue().equals(deviceIp) || !devicePort.equals(netconfNode.getPort().getValue().toString())) continue;
                return node;
            }
        }
        return null;
    }

    private static boolean isNetconfNodesPresent(Topology topology) {
        return topology != null && topology.getNode() != null && !topology.getNode().isEmpty();
    }

    public static <D extends DataObject> D read(LogicalDatastoreType store, InstanceIdentifier<D> path, DataBroker db) {
        Optional optionalData;
        FluentFuture future;
        try (ReadTransaction transaction = db.newReadOnlyTransaction();){
            future = transaction.read(store, path);
        }
        try {
            optionalData = (Optional)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to read {} ", path, (Object)e);
            return null;
        }
        if (optionalData.isPresent()) {
            return (D)((DataObject)optionalData.get());
        }
        LOG.debug("{}: Failed to read {}", (Object)Thread.currentThread().getStackTrace()[1], path);
        return null;
    }
}

