/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Statistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatisticsBuilder
implements Builder<Statistics> {
    private ZeroBasedCounter32 _droppedSessions;
    private ZeroBasedCounter32 _inBadHellos;
    private ZeroBasedCounter32 _inBadRpcs;
    private ZeroBasedCounter32 _inRpcs;
    private ZeroBasedCounter32 _inSessions;
    private DateAndTime _netconfStartTime;
    private ZeroBasedCounter32 _outNotifications;
    private ZeroBasedCounter32 _outRpcErrors;
    Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = Collections.emptyMap();

    public StatisticsBuilder() {
    }

    public StatisticsBuilder(CommonCounters arg) {
        this._inRpcs = arg.getInRpcs();
        this._inBadRpcs = arg.getInBadRpcs();
        this._outRpcErrors = arg.getOutRpcErrors();
        this._outNotifications = arg.getOutNotifications();
    }

    public StatisticsBuilder(Statistics base) {
        Map aug;
        this._droppedSessions = base.getDroppedSessions();
        this._inBadHellos = base.getInBadHellos();
        this._inBadRpcs = base.getInBadRpcs();
        this._inRpcs = base.getInRpcs();
        this._inSessions = base.getInSessions();
        this._netconfStartTime = base.getNetconfStartTime();
        this._outNotifications = base.getOutNotifications();
        this._outRpcErrors = base.getOutRpcErrors();
        if (base instanceof StatisticsImpl) {
            StatisticsImpl impl = (StatisticsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonCounters) {
            this._inRpcs = ((CommonCounters)arg).getInRpcs();
            this._inBadRpcs = ((CommonCounters)arg).getInBadRpcs();
            this._outRpcErrors = ((CommonCounters)arg).getOutRpcErrors();
            this._outNotifications = ((CommonCounters)arg).getOutNotifications();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters]");
    }

    public ZeroBasedCounter32 getDroppedSessions() {
        return this._droppedSessions;
    }

    public ZeroBasedCounter32 getInBadHellos() {
        return this._inBadHellos;
    }

    public ZeroBasedCounter32 getInBadRpcs() {
        return this._inBadRpcs;
    }

    public ZeroBasedCounter32 getInRpcs() {
        return this._inRpcs;
    }

    public ZeroBasedCounter32 getInSessions() {
        return this._inSessions;
    }

    public DateAndTime getNetconfStartTime() {
        return this._netconfStartTime;
    }

    public ZeroBasedCounter32 getOutNotifications() {
        return this._outNotifications;
    }

    public ZeroBasedCounter32 getOutRpcErrors() {
        return this._outRpcErrors;
    }

    public <E$$ extends Augmentation<Statistics>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public StatisticsBuilder setDroppedSessions(ZeroBasedCounter32 value) {
        this._droppedSessions = value;
        return this;
    }

    public StatisticsBuilder setInBadHellos(ZeroBasedCounter32 value) {
        this._inBadHellos = value;
        return this;
    }

    public StatisticsBuilder setInBadRpcs(ZeroBasedCounter32 value) {
        this._inBadRpcs = value;
        return this;
    }

    public StatisticsBuilder setInRpcs(ZeroBasedCounter32 value) {
        this._inRpcs = value;
        return this;
    }

    public StatisticsBuilder setInSessions(ZeroBasedCounter32 value) {
        this._inSessions = value;
        return this;
    }

    public StatisticsBuilder setNetconfStartTime(DateAndTime value) {
        this._netconfStartTime = value;
        return this;
    }

    public StatisticsBuilder setOutNotifications(ZeroBasedCounter32 value) {
        this._outNotifications = value;
        return this;
    }

    public StatisticsBuilder setOutRpcErrors(ZeroBasedCounter32 value) {
        this._outRpcErrors = value;
        return this;
    }

    public StatisticsBuilder addAugmentation(Class<? extends Augmentation<Statistics>> augmentationType, Augmentation<Statistics> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StatisticsBuilder removeAugmentation(Class<? extends Augmentation<Statistics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Statistics build() {
        return new StatisticsImpl(this);
    }

    private static final class StatisticsImpl
    implements Statistics {
        private final ZeroBasedCounter32 _droppedSessions;
        private final ZeroBasedCounter32 _inBadHellos;
        private final ZeroBasedCounter32 _inBadRpcs;
        private final ZeroBasedCounter32 _inRpcs;
        private final ZeroBasedCounter32 _inSessions;
        private final DateAndTime _netconfStartTime;
        private final ZeroBasedCounter32 _outNotifications;
        private final ZeroBasedCounter32 _outRpcErrors;
        private Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        StatisticsImpl(StatisticsBuilder base) {
            this._droppedSessions = base.getDroppedSessions();
            this._inBadHellos = base.getInBadHellos();
            this._inBadRpcs = base.getInBadRpcs();
            this._inRpcs = base.getInRpcs();
            this._inSessions = base.getInSessions();
            this._netconfStartTime = base.getNetconfStartTime();
            this._outNotifications = base.getOutNotifications();
            this._outRpcErrors = base.getOutRpcErrors();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Statistics> getImplementedInterface() {
            return Statistics.class;
        }

        @Override
        public ZeroBasedCounter32 getDroppedSessions() {
            return this._droppedSessions;
        }

        @Override
        public ZeroBasedCounter32 getInBadHellos() {
            return this._inBadHellos;
        }

        @Override
        public ZeroBasedCounter32 getInBadRpcs() {
            return this._inBadRpcs;
        }

        @Override
        public ZeroBasedCounter32 getInRpcs() {
            return this._inRpcs;
        }

        @Override
        public ZeroBasedCounter32 getInSessions() {
            return this._inSessions;
        }

        @Override
        public DateAndTime getNetconfStartTime() {
            return this._netconfStartTime;
        }

        @Override
        public ZeroBasedCounter32 getOutNotifications() {
            return this._outNotifications;
        }

        @Override
        public ZeroBasedCounter32 getOutRpcErrors() {
            return this._outRpcErrors;
        }

        public <E$$ extends Augmentation<Statistics>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._droppedSessions);
            result = 31 * result + Objects.hashCode(this._inBadHellos);
            result = 31 * result + Objects.hashCode(this._inBadRpcs);
            result = 31 * result + Objects.hashCode(this._inRpcs);
            result = 31 * result + Objects.hashCode(this._inSessions);
            result = 31 * result + Objects.hashCode(this._netconfStartTime);
            result = 31 * result + Objects.hashCode(this._outNotifications);
            result = 31 * result + Objects.hashCode(this._outRpcErrors);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Statistics.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Statistics other = (Statistics)obj;
            if (!Objects.equals(this._droppedSessions, other.getDroppedSessions())) {
                return false;
            }
            if (!Objects.equals(this._inBadHellos, other.getInBadHellos())) {
                return false;
            }
            if (!Objects.equals(this._inBadRpcs, other.getInBadRpcs())) {
                return false;
            }
            if (!Objects.equals(this._inRpcs, other.getInRpcs())) {
                return false;
            }
            if (!Objects.equals(this._inSessions, other.getInSessions())) {
                return false;
            }
            if (!Objects.equals(this._netconfStartTime, other.getNetconfStartTime())) {
                return false;
            }
            if (!Objects.equals(this._outNotifications, other.getOutNotifications())) {
                return false;
            }
            if (!Objects.equals(this._outRpcErrors, other.getOutRpcErrors())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatisticsImpl otherImpl = (StatisticsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Statistics");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_droppedSessions", (Object)this._droppedSessions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inBadHellos", (Object)this._inBadHellos);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inBadRpcs", (Object)this._inBadRpcs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inRpcs", (Object)this._inRpcs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inSessions", (Object)this._inSessions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_netconfStartTime", (Object)this._netconfStartTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_outNotifications", (Object)this._outNotifications);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_outRpcErrors", (Object)this._outRpcErrors);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

