/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.lock.type.global.lock;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.LockInfo;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.lock.type.global.lock.GlobalLock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GlobalLockBuilder
implements Builder<GlobalLock> {
    private Long _lockedBySession;
    private DateAndTime _lockedTime;
    Map<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>> augmentation = Collections.emptyMap();

    public GlobalLockBuilder() {
    }

    public GlobalLockBuilder(LockInfo arg) {
        this._lockedBySession = arg.getLockedBySession();
        this._lockedTime = arg.getLockedTime();
    }

    public GlobalLockBuilder(GlobalLock base) {
        Map aug;
        this._lockedBySession = base.getLockedBySession();
        this._lockedTime = base.getLockedTime();
        if (base instanceof GlobalLockImpl) {
            GlobalLockImpl impl = (GlobalLockImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LockInfo) {
            this._lockedBySession = ((LockInfo)arg).getLockedBySession();
            this._lockedTime = ((LockInfo)arg).getLockedTime();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.datastores.datastore.locks.LockInfo]");
    }

    public Long getLockedBySession() {
        return this._lockedBySession;
    }

    public DateAndTime getLockedTime() {
        return this._lockedTime;
    }

    public <E$$ extends Augmentation<GlobalLock>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkLockedBySessionRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public GlobalLockBuilder setLockedBySession(Long value) {
        if (value != null) {
            GlobalLockBuilder.checkLockedBySessionRange(value);
        }
        this._lockedBySession = value;
        return this;
    }

    public GlobalLockBuilder setLockedTime(DateAndTime value) {
        this._lockedTime = value;
        return this;
    }

    public GlobalLockBuilder addAugmentation(Class<? extends Augmentation<GlobalLock>> augmentationType, Augmentation<GlobalLock> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GlobalLockBuilder removeAugmentation(Class<? extends Augmentation<GlobalLock>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GlobalLock build() {
        return new GlobalLockImpl(this);
    }

    private static final class GlobalLockImpl
    implements GlobalLock {
        private final Long _lockedBySession;
        private final DateAndTime _lockedTime;
        private Map<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        GlobalLockImpl(GlobalLockBuilder base) {
            this._lockedBySession = base.getLockedBySession();
            this._lockedTime = base.getLockedTime();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<GlobalLock> getImplementedInterface() {
            return GlobalLock.class;
        }

        @Override
        public Long getLockedBySession() {
            return this._lockedBySession;
        }

        @Override
        public DateAndTime getLockedTime() {
            return this._lockedTime;
        }

        public <E$$ extends Augmentation<GlobalLock>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lockedBySession);
            result = 31 * result + Objects.hashCode(this._lockedTime);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GlobalLock.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GlobalLock other = (GlobalLock)obj;
            if (!Objects.equals(this._lockedBySession, other.getLockedBySession())) {
                return false;
            }
            if (!Objects.equals(this._lockedTime, other.getLockedTime())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GlobalLockImpl otherImpl = (GlobalLockImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GlobalLock>>, Augmentation<GlobalLock>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"GlobalLock");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockedBySession", (Object)this._lockedBySession);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lockedTime", (Object)this._lockedTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

