/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.SchemaFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SchemaBuilder
implements Builder<Schema> {
    private Class<? extends SchemaFormat> _format;
    private String _identifier;
    private List<Schema.Location> _location;
    private Uri _namespace;
    private String _version;
    private SchemaKey key;
    Map<Class<? extends Augmentation<Schema>>, Augmentation<Schema>> augmentation = Collections.emptyMap();

    public SchemaBuilder() {
    }

    public SchemaBuilder(Schema base) {
        Map aug;
        this.key = base.key();
        this._format = base.getFormat();
        this._identifier = base.getIdentifier();
        this._version = base.getVersion();
        this._location = base.getLocation();
        this._namespace = base.getNamespace();
        if (base instanceof SchemaImpl) {
            SchemaImpl impl = (SchemaImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Schema>>, Augmentation<Schema>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Schema>>, Augmentation<Schema>>(aug);
        }
    }

    public SchemaKey key() {
        return this.key;
    }

    public Class<? extends SchemaFormat> getFormat() {
        return this._format;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public List<Schema.Location> getLocation() {
        return this._location;
    }

    public Uri getNamespace() {
        return this._namespace;
    }

    public String getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<Schema>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SchemaBuilder withKey(SchemaKey key) {
        this.key = key;
        return this;
    }

    public SchemaBuilder setFormat(Class<? extends SchemaFormat> value) {
        this._format = value;
        return this;
    }

    public SchemaBuilder setIdentifier(String value) {
        this._identifier = value;
        return this;
    }

    public SchemaBuilder setLocation(List<Schema.Location> values) {
        this._location = values;
        return this;
    }

    public SchemaBuilder setNamespace(Uri value) {
        this._namespace = value;
        return this;
    }

    public SchemaBuilder setVersion(String value) {
        this._version = value;
        return this;
    }

    public SchemaBuilder addAugmentation(Class<? extends Augmentation<Schema>> augmentationType, Augmentation<Schema> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Schema>>, Augmentation<Schema>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SchemaBuilder removeAugmentation(Class<? extends Augmentation<Schema>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Schema build() {
        return new SchemaImpl(this);
    }

    private static final class SchemaImpl
    implements Schema {
        private final Class<? extends SchemaFormat> _format;
        private final String _identifier;
        private final List<Schema.Location> _location;
        private final Uri _namespace;
        private final String _version;
        private final SchemaKey key;
        private Map<Class<? extends Augmentation<Schema>>, Augmentation<Schema>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SchemaImpl(SchemaBuilder base) {
            this.key = base.key() != null ? base.key() : new SchemaKey(base.getFormat(), base.getIdentifier(), base.getVersion());
            this._format = this.key.getFormat();
            this._identifier = this.key.getIdentifier();
            this._version = this.key.getVersion();
            this._location = base.getLocation();
            this._namespace = base.getNamespace();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Schema> getImplementedInterface() {
            return Schema.class;
        }

        @Override
        public SchemaKey key() {
            return this.key;
        }

        @Override
        public Class<? extends SchemaFormat> getFormat() {
            return this._format;
        }

        @Override
        public String getIdentifier() {
            return this._identifier;
        }

        @Override
        public List<Schema.Location> getLocation() {
            return this._location;
        }

        @Override
        public Uri getNamespace() {
            return this._namespace;
        }

        @Override
        public String getVersion() {
            return this._version;
        }

        public <E$$ extends Augmentation<Schema>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._format);
            result = 31 * result + Objects.hashCode(this._identifier);
            result = 31 * result + Objects.hashCode(this._location);
            result = 31 * result + Objects.hashCode(this._namespace);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Schema.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Schema other = (Schema)obj;
            if (!Objects.equals(this._format, other.getFormat())) {
                return false;
            }
            if (!Objects.equals(this._identifier, other.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this._location, other.getLocation())) {
                return false;
            }
            if (!Objects.equals(this._namespace, other.getNamespace())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SchemaImpl otherImpl = (SchemaImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Schema>>, Augmentation<Schema>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Schema");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_format", this._format);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_identifier", (Object)this._identifier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_location", this._location);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_namespace", (Object)this._namespace);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_version", (Object)this._version);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

