/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Transport;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SessionBuilder
implements Builder<Session> {
    private ZeroBasedCounter32 _inBadRpcs;
    private ZeroBasedCounter32 _inRpcs;
    private DateAndTime _loginTime;
    private ZeroBasedCounter32 _outNotifications;
    private ZeroBasedCounter32 _outRpcErrors;
    private Long _sessionId;
    private Host _sourceHost;
    private Class<? extends Transport> _transport;
    private String _username;
    private SessionKey key;
    Map<Class<? extends Augmentation<Session>>, Augmentation<Session>> augmentation = Collections.emptyMap();

    public SessionBuilder() {
    }

    public SessionBuilder(CommonCounters arg) {
        this._inRpcs = arg.getInRpcs();
        this._inBadRpcs = arg.getInBadRpcs();
        this._outRpcErrors = arg.getOutRpcErrors();
        this._outNotifications = arg.getOutNotifications();
    }

    public SessionBuilder(Session base) {
        Map aug;
        this.key = base.key();
        this._sessionId = base.getSessionId();
        this._inBadRpcs = base.getInBadRpcs();
        this._inRpcs = base.getInRpcs();
        this._loginTime = base.getLoginTime();
        this._outNotifications = base.getOutNotifications();
        this._outRpcErrors = base.getOutRpcErrors();
        this._sourceHost = base.getSourceHost();
        this._transport = base.getTransport();
        this._username = base.getUsername();
        if (base instanceof SessionImpl) {
            SessionImpl impl = (SessionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Session>>, Augmentation<Session>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Session>>, Augmentation<Session>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonCounters) {
            this._inRpcs = ((CommonCounters)arg).getInRpcs();
            this._inBadRpcs = ((CommonCounters)arg).getInBadRpcs();
            this._outRpcErrors = ((CommonCounters)arg).getOutRpcErrors();
            this._outNotifications = ((CommonCounters)arg).getOutNotifications();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters]");
    }

    public SessionKey key() {
        return this.key;
    }

    public ZeroBasedCounter32 getInBadRpcs() {
        return this._inBadRpcs;
    }

    public ZeroBasedCounter32 getInRpcs() {
        return this._inRpcs;
    }

    public DateAndTime getLoginTime() {
        return this._loginTime;
    }

    public ZeroBasedCounter32 getOutNotifications() {
        return this._outNotifications;
    }

    public ZeroBasedCounter32 getOutRpcErrors() {
        return this._outRpcErrors;
    }

    public Long getSessionId() {
        return this._sessionId;
    }

    public Host getSourceHost() {
        return this._sourceHost;
    }

    public Class<? extends Transport> getTransport() {
        return this._transport;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<Session>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SessionBuilder withKey(SessionKey key) {
        this.key = key;
        return this;
    }

    public SessionBuilder setInBadRpcs(ZeroBasedCounter32 value) {
        this._inBadRpcs = value;
        return this;
    }

    public SessionBuilder setInRpcs(ZeroBasedCounter32 value) {
        this._inRpcs = value;
        return this;
    }

    public SessionBuilder setLoginTime(DateAndTime value) {
        this._loginTime = value;
        return this;
    }

    public SessionBuilder setOutNotifications(ZeroBasedCounter32 value) {
        this._outNotifications = value;
        return this;
    }

    public SessionBuilder setOutRpcErrors(ZeroBasedCounter32 value) {
        this._outRpcErrors = value;
        return this;
    }

    private static void checkSessionIdRange(long value) {
        if (value >= 1L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4294967295]]", (long)value);
    }

    public SessionBuilder setSessionId(Long value) {
        if (value != null) {
            SessionBuilder.checkSessionIdRange(value);
        }
        this._sessionId = value;
        return this;
    }

    public SessionBuilder setSourceHost(Host value) {
        this._sourceHost = value;
        return this;
    }

    public SessionBuilder setTransport(Class<? extends Transport> value) {
        this._transport = value;
        return this;
    }

    public SessionBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public SessionBuilder addAugmentation(Class<? extends Augmentation<Session>> augmentationType, Augmentation<Session> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Session>>, Augmentation<Session>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SessionBuilder removeAugmentation(Class<? extends Augmentation<Session>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Session build() {
        return new SessionImpl(this);
    }

    private static final class SessionImpl
    implements Session {
        private final ZeroBasedCounter32 _inBadRpcs;
        private final ZeroBasedCounter32 _inRpcs;
        private final DateAndTime _loginTime;
        private final ZeroBasedCounter32 _outNotifications;
        private final ZeroBasedCounter32 _outRpcErrors;
        private final Long _sessionId;
        private final Host _sourceHost;
        private final Class<? extends Transport> _transport;
        private final String _username;
        private final SessionKey key;
        private Map<Class<? extends Augmentation<Session>>, Augmentation<Session>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SessionImpl(SessionBuilder base) {
            this.key = base.key() != null ? base.key() : new SessionKey(base.getSessionId());
            this._sessionId = this.key.getSessionId();
            this._inBadRpcs = base.getInBadRpcs();
            this._inRpcs = base.getInRpcs();
            this._loginTime = base.getLoginTime();
            this._outNotifications = base.getOutNotifications();
            this._outRpcErrors = base.getOutRpcErrors();
            this._sourceHost = base.getSourceHost();
            this._transport = base.getTransport();
            this._username = base.getUsername();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Session> getImplementedInterface() {
            return Session.class;
        }

        @Override
        public SessionKey key() {
            return this.key;
        }

        @Override
        public ZeroBasedCounter32 getInBadRpcs() {
            return this._inBadRpcs;
        }

        @Override
        public ZeroBasedCounter32 getInRpcs() {
            return this._inRpcs;
        }

        @Override
        public DateAndTime getLoginTime() {
            return this._loginTime;
        }

        @Override
        public ZeroBasedCounter32 getOutNotifications() {
            return this._outNotifications;
        }

        @Override
        public ZeroBasedCounter32 getOutRpcErrors() {
            return this._outRpcErrors;
        }

        @Override
        public Long getSessionId() {
            return this._sessionId;
        }

        @Override
        public Host getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public Class<? extends Transport> getTransport() {
            return this._transport;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public <E$$ extends Augmentation<Session>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._inBadRpcs);
            result = 31 * result + Objects.hashCode(this._inRpcs);
            result = 31 * result + Objects.hashCode(this._loginTime);
            result = 31 * result + Objects.hashCode(this._outNotifications);
            result = 31 * result + Objects.hashCode(this._outRpcErrors);
            result = 31 * result + Objects.hashCode(this._sessionId);
            result = 31 * result + Objects.hashCode(this._sourceHost);
            result = 31 * result + Objects.hashCode(this._transport);
            result = 31 * result + Objects.hashCode(this._username);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Session.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Session other = (Session)obj;
            if (!Objects.equals(this._inBadRpcs, other.getInBadRpcs())) {
                return false;
            }
            if (!Objects.equals(this._inRpcs, other.getInRpcs())) {
                return false;
            }
            if (!Objects.equals(this._loginTime, other.getLoginTime())) {
                return false;
            }
            if (!Objects.equals(this._outNotifications, other.getOutNotifications())) {
                return false;
            }
            if (!Objects.equals(this._outRpcErrors, other.getOutRpcErrors())) {
                return false;
            }
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (!Objects.equals(this._sourceHost, other.getSourceHost())) {
                return false;
            }
            if (!Objects.equals(this._transport, other.getTransport())) {
                return false;
            }
            if (!Objects.equals(this._username, other.getUsername())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SessionImpl otherImpl = (SessionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Session>>, Augmentation<Session>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Session");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inBadRpcs", (Object)this._inBadRpcs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inRpcs", (Object)this._inRpcs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_loginTime", (Object)this._loginTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_outNotifications", (Object)this._outNotifications);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_outRpcErrors", (Object)this._outRpcErrors);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sessionId", (Object)this._sessionId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceHost", (Object)this._sourceHost);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transport", this._transport);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_username", (Object)this._username);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

