/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class VlanId
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -3708880084115267596L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 0 && value <= 4095) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4095]]", (int)value);
    }

    @ConstructorProperties(value={"value"})
    public VlanId(Integer _value) {
        if (_value != null) {
            VlanId.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public VlanId(VlanId source) {
        this._value = source._value;
    }

    public static VlanId getDefaultInstance(String defaultValue) {
        return new VlanId(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VlanId other = (VlanId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(VlanId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

