/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl.bda;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public abstract class AbstractClassLoaderResourceLoader
implements ResourceLoader {
    private static final String ERROR_LOADING_CLASS = "Error loading class ";

    public Class<?> classForName(String name) {
        try {
            return this.classLoader().loadClass(name);
        }
        catch (ClassNotFoundException | LinkageError | TypeNotPresentException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, e);
        }
    }

    public URL getResource(String name) {
        return this.classLoader().getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            return Collections.list(this.classLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    protected abstract ClassLoader classLoader();
}

