/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl.util;

import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Types;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.ops4j.pax.cdi.weld.impl.util.BundleClassLoader;
import org.ops4j.pax.cdi.weld.impl.util.DelegatingBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiProxyService
implements ProxyServices {
    private final BeanManager manager;
    private final DelegatingBundle delegate;
    private final ClassLoader loader;

    public OsgiProxyService(BeanManager manager, ClassLoader parent) {
        this.manager = manager;
        this.delegate = new DelegatingBundle(FrameworkUtil.getBundle(LifecycleMixin.class));
        this.loader = new BundleClassLoader(this.delegate, parent);
    }

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        if (!Modifier.isPublic(proxiedBeanType.getModifiers()) && !Modifier.isProtected(proxiedBeanType.getModifiers())) {
            return proxiedBeanType.getClassLoader();
        }
        for (Class type : Types.getRawTypes((Set)this.manager.createAnnotatedType(proxiedBeanType).getTypeClosure())) {
            Bundle bundle = FrameworkUtil.getBundle((Class)type);
            if (bundle == null) continue;
            this.delegate.addBundle(bundle);
        }
        return this.loader;
    }

    public Class<?> loadBeanClass(String className) {
        try {
            return (Class)AccessController.doPrivileged(new LoadClass(className));
        }
        catch (PrivilegedActionException pae) {
            throw Exceptions.unchecked((Throwable)pae);
        }
    }

    public void cleanup() {
    }

    private class LoadClass
    implements PrivilegedExceptionAction<Class<?>> {
        private final String className;

        private LoadClass(String className) {
            this.className = className;
        }

        @Override
        public Class<?> run() throws ClassNotFoundException {
            return Class.forName(this.className, true, OsgiProxyService.this.loader);
        }
    }
}

