/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.opendaylight.netconf.shaded.apache.xml.serialize.HTMLSerializer;
import org.opendaylight.netconf.shaded.apache.xml.serialize.OutputFormat;
import org.opendaylight.netconf.shaded.apache.xml.serialize.Serializer;
import org.opendaylight.netconf.shaded.apache.xml.serialize.SerializerFactory;
import org.opendaylight.netconf.shaded.apache.xml.serialize.TextSerializer;
import org.opendaylight.netconf.shaded.apache.xml.serialize.XHTMLSerializer;
import org.opendaylight.netconf.shaded.apache.xml.serialize.XMLSerializer;
import org.opendaylight.netconf.shaded.xerces.dom.DOMMessageFormatter;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string) {
        this._method = string;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string});
            throw new IllegalArgumentException(string2);
        }
    }

    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputByteStream(outputStream);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String string = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(string);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

