/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.coder;

import java.io.IOException;
import org.opendaylight.netconf.shaded.exificient.core.EXIBodyDecoder;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.coder.AbstractEXIBodyCoder;
import org.opendaylight.netconf.shaded.exificient.core.container.DocType;
import org.opendaylight.netconf.shaded.exificient.core.container.NamespaceDeclaration;
import org.opendaylight.netconf.shaded.exificient.core.container.ProcessingInstruction;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarContext;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarUriContext;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringDecoder;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Attribute;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.AttributeNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Characters;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Event;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElementNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Grammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.GrammarType;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltIn;
import org.opendaylight.netconf.shaded.exificient.core.types.TypeDecoder;
import org.opendaylight.netconf.shaded.exificient.core.util.MethodsBag;
import org.opendaylight.netconf.shaded.exificient.core.util.xml.QNameUtilities;
import org.opendaylight.netconf.shaded.exificient.core.values.BooleanValue;
import org.opendaylight.netconf.shaded.exificient.core.values.QNameValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;

public abstract class AbstractEXIBodyDecoder
extends AbstractEXIBodyCoder
implements EXIBodyDecoder {
    protected Event nextEvent;
    protected Grammar nextGrammar;
    protected EventType nextEventType;
    protected DecoderChannel channel;
    protected final int numberOfUriContexts;
    protected final TypeDecoder typeDecoder;
    protected final StringDecoder stringDecoder;
    protected QNameContext attributeQNameContext;
    protected String attributePrefix;
    protected Value attributeValue;

    public AbstractEXIBodyDecoder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.typeDecoder = exiFactory.createTypeDecoder();
        this.stringDecoder = exiFactory.createStringDecoder();
        this.numberOfUriContexts = this.grammar.getGrammarContext().getNumberOfGrammarUriContexts();
    }

    protected final void pushElement(Grammar updContextGrammar, StartElement se) {
        super.pushElement(updContextGrammar, se);
        if (!this.preservePrefix && this.elementContextStackIndex == 1) {
            GrammarContext gc = this.grammar.getGrammarContext();
            for (int i = 2; i < gc.getNumberOfGrammarUriContexts(); ++i) {
                GrammarUriContext guc = gc.getGrammarUriContext(i);
                String pfx = guc.getDefaultPrefix();
                this.declarePrefix(pfx, guc.getNamespaceUri());
            }
        }
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.stringDecoder.clear();
        if (this.exiFactory.getSharedStrings() != null) {
            this.stringDecoder.setSharedStrings(this.exiFactory.getSharedStrings());
        }
    }

    protected QNameContext decodeQName(DecoderChannel channel) throws IOException {
        return this.decodeLocalName(this.decodeUri(channel), channel);
    }

    protected AbstractEXIBodyCoder.RuntimeUriContext decodeUri(DecoderChannel channel) throws IOException {
        AbstractEXIBodyCoder.RuntimeUriContext uc;
        int numberBitsUri = MethodsBag.getCodingLength(this.getNumberOfUris() + 1);
        int uriID = channel.decodeNBitUnsignedInteger(numberBitsUri);
        if (uriID == 0) {
            String uri = new String(channel.decodeString());
            uc = this.addUri(uri);
        } else {
            uc = this.getUri(--uriID);
        }
        return uc;
    }

    protected QNameContext decodeLocalName(AbstractEXIBodyCoder.RuntimeUriContext uc, DecoderChannel channel) throws IOException {
        QNameContext qnc;
        int length = channel.decodeUnsignedInteger();
        if (length > 0) {
            String localName = new String(channel.decodeStringOnly(length - 1));
            qnc = uc.addQNameContext(localName);
        } else {
            int n = MethodsBag.getCodingLength(uc.getNumberOfQNames());
            int localNameID = channel.decodeNBitUnsignedInteger(n);
            qnc = uc.getQNameContext(localNameID);
        }
        return qnc;
    }

    protected String decodeQNamePrefix(AbstractEXIBodyCoder.RuntimeUriContext uc, DecoderChannel channel) throws IOException {
        String prefix = null;
        if (uc.namespaceUriID == 0) {
            prefix = "";
        } else {
            int numberOfPrefixes = uc.getNumberOfPrefixes();
            if (numberOfPrefixes > 0) {
                int id = 0;
                if (numberOfPrefixes > 1) {
                    id = channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(numberOfPrefixes));
                }
                prefix = uc.getPrefix(id);
            }
        }
        return prefix;
    }

    protected String decodeNamespacePrefix(AbstractEXIBodyCoder.RuntimeUriContext uc, DecoderChannel channel) throws IOException {
        String prefix;
        int nPfx = MethodsBag.getCodingLength(uc.getNumberOfPrefixes() + 1);
        int pfxID = channel.decodeNBitUnsignedInteger(nPfx);
        if (pfxID == 0) {
            prefix = new String(channel.decodeString());
            uc.addPrefix(prefix);
        } else {
            prefix = uc.getPrefix(pfxID - 1);
        }
        return prefix;
    }

    protected final EventType decodeEventCode() throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        int codeLength = this.fidelityOptions.get1stLevelEventCodeLength(currentGrammar);
        int ec = this.channel.decodeNBitUnsignedInteger(codeLength);
        assert (ec >= 0);
        if (ec < currentGrammar.getNumberOfEvents()) {
            Production ei = currentGrammar.getProduction(ec);
            this.nextEvent = ei.getEvent();
            this.nextGrammar = ei.getNextGrammar();
            this.nextEventType = this.nextEvent.getEventType();
        } else {
            int ec2 = this.decode2ndLevelEventCode();
            if (ec2 == -1) {
                int ec3 = this.decode3rdLevelEventCode();
                this.nextEventType = this.fidelityOptions.get3rdLevelEventType(ec3);
                this.nextEvent = null;
                this.nextGrammar = null;
            } else {
                this.nextEventType = this.fidelityOptions.get2ndLevelEventType(ec2, currentGrammar);
                if (this.nextEventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    this.updateInvalidValueAttribute(ec);
                } else {
                    this.nextEvent = null;
                    this.nextGrammar = null;
                }
            }
        }
        return this.nextEventType;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public String getAttributeQNameAsString() {
        if (this.preservePrefix) {
            return QNameUtilities.getQualifiedName(this.attributeQNameContext.getLocalName(), this.attributePrefix);
        }
        return this.attributeQNameContext.getDefaultQNameAsString();
    }

    public Value getAttributeValue() {
        return this.attributeValue;
    }

    protected void updateInvalidValueAttribute(int ec) throws EXIException {
        int ec3AT;
        SchemaInformedGrammar sir = (SchemaInformedGrammar)this.getCurrentGrammar();
        try {
            ec3AT = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(sir.getNumberOfDeclaredAttributes() + 1));
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
        if (ec3AT < sir.getNumberOfDeclaredAttributes()) {
            ec = ec3AT + sir.getLeastAttributeEventCode();
            Production ei = sir.getProduction(ec);
            this.nextEvent = ei.getEvent();
            this.nextGrammar = ei.getNextGrammar();
        } else if (ec3AT == sir.getNumberOfDeclaredAttributes()) {
            this.nextEventType = EventType.ATTRIBUTE_ANY_INVALID_VALUE;
        } else {
            throw new EXIException("Error occured while decoding deviated attribute");
        }
    }

    protected int decode2ndLevelEventCode() throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        int ch2 = this.fidelityOptions.get2ndLevelCharacteristics(currentGrammar);
        int level2 = this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch2));
        int ch3 = this.fidelityOptions.get3rdLevelCharacteristics();
        if (ch3 > 0) {
            return level2 < ch2 - 1 ? level2 : -1;
        }
        return level2 < ch2 ? level2 : -1;
    }

    protected int decode3rdLevelEventCode() throws EXIException, IOException {
        int ch3 = this.fidelityOptions.get3rdLevelCharacteristics();
        return this.channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(ch3));
    }

    protected final void decodeStartDocumentStructure() throws EXIException {
        this.updateCurrentRule(this.getCurrentGrammar().getProduction(0).getNextGrammar());
    }

    protected final void decodeEndDocumentStructure() throws EXIException, IOException {
        if (this.limitGrammarLearning && this.maxBuiltInElementGrammars != -1) {
            int evolvedGrs = 0;
            for (StartElement se : this.runtimeGlobalElements.values()) {
                Grammar stg = se.getGrammar();
                assert (stg.getGrammarType() == GrammarType.BUILT_IN_START_TAG_CONTENT);
                Grammar ecg = stg.getElementContentGrammar();
                assert (ecg.getGrammarType() == GrammarType.BUILT_IN_ELEMENT_CONTENT);
                if (ecg.getNumberOfEvents() != 1) {
                    ++evolvedGrs;
                    continue;
                }
                if (stg.getNumberOfEvents() > 1) {
                    ++evolvedGrs;
                    continue;
                }
                if (stg.getNumberOfEvents() != 1 || this.isBuiltInStartTagGrammarWithAtXsiTypeOnly(stg)) continue;
                ++evolvedGrs;
            }
            if (evolvedGrs > this.maxBuiltInElementGrammars) {
                throw new RuntimeException("EXI profile stream does not respect parameter maxBuiltInElementGrammars. Expected " + this.maxBuiltInElementGrammars + " but was " + evolvedGrs);
            }
        }
    }

    protected final QNameContext decodeStartElementStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT);
        StartElement se = (StartElement)this.nextEvent;
        this.pushElement(this.nextGrammar, se);
        QNameContext qnc = se.getQNameContext();
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementNSStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_NS);
        StartElementNS seNS = (StartElementNS)this.nextEvent;
        AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(seNS.getNamespaceUriID());
        QNameContext qnc = this.decodeLocalName(uc, this.channel);
        StartElement nextSE = this.getGlobalStartElement(qnc);
        this.pushElement(this.nextGrammar, nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementGenericStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC);
        QNameContext qnc = this.decodeQName(this.channel);
        StartElement nextSE = this.getGlobalStartElement(qnc);
        this.getCurrentGrammar().learnStartElement(nextSE);
        this.pushElement(this.nextGrammar.getElementContentGrammar(), nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final QNameContext decodeStartElementGenericUndeclaredStructure() throws IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC_UNDECLARED);
        QNameContext qnc = this.decodeQName(this.channel);
        StartElement nextSE = this.getGlobalStartElement(qnc);
        Grammar currentGrammar = this.getCurrentGrammar();
        currentGrammar.learnStartElement(nextSE);
        this.pushElement(currentGrammar.getElementContentGrammar(), nextSE);
        this.handleElementPrefix(qnc);
        return qnc;
    }

    protected final AbstractEXIBodyCoder.ElementContext decodeEndElementStructure() throws EXIException, IOException {
        return this.popElement();
    }

    protected final AbstractEXIBodyCoder.ElementContext decodeEndElementUndeclaredStructure() throws EXIException, IOException {
        this.getCurrentGrammar().learnEndElement();
        return this.popElement();
    }

    protected final void decodeAttributeXsiNilStructure() throws EXIException, IOException {
        BooleanValue bv;
        this.attributeQNameContext = this.getXsiNilContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        this.attributeValue = this.preserveLexicalValues ? this.typeDecoder.readValue(this.booleanDatatype, this.getXsiNilContext(), this.channel, this.stringDecoder) : this.channel.decodeBooleanValue();
        boolean xsiNil = false;
        if (this.attributeValue instanceof BooleanValue) {
            bv = (BooleanValue)this.attributeValue;
            xsiNil = bv.toBoolean();
        } else if (this.attributeValue instanceof BooleanValue) {
            xsiNil = ((BooleanValue)this.attributeValue).toBoolean();
        } else {
            bv = BooleanValue.parse(this.attributeValue.toString());
            if (bv != null) {
                xsiNil = bv.toBoolean();
            }
        }
        Grammar currentGrammar = this.getCurrentGrammar();
        if (xsiNil && currentGrammar.isSchemaInformed()) {
            this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)currentGrammar).getTypeEmpty());
        }
    }

    protected final void decodeAttributeXsiTypeStructure() throws EXIException, IOException {
        this.attributeQNameContext = this.getXsiTypeContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        QNameContext qncType = null;
        if (this.preserveLexicalValues) {
            this.attributeValue = this.typeDecoder.readValue(BuiltIn.getDefaultDatatype(), this.getXsiTypeContext(), this.channel, this.stringDecoder);
            String sType = this.attributeValue.toString();
            String qncTypePrefix = QNameUtilities.getPrefixPart(sType);
            String qnameURI = this.getURI(qncTypePrefix);
            AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(qnameURI);
            if (uc != null) {
                String qnameLocalName = QNameUtilities.getLocalPart(sType);
                qncType = uc.getQNameContext(qnameLocalName);
            }
        } else {
            String qncTypePrefix;
            qncType = this.decodeQName(this.channel);
            if (this.preservePrefix) {
                qncTypePrefix = this.decodeQNamePrefix(this.getUri(qncType.getNamespaceUriID()), this.channel);
            } else {
                this.checkDefaultPrefixNamespaceDeclaration(qncType);
                qncTypePrefix = qncType.getDefaultPrefix();
            }
            this.attributeValue = new QNameValue(qncType.getNamespaceUri(), qncType.getLocalName(), qncTypePrefix);
        }
        if (qncType != null && qncType.getTypeGrammar() != null) {
            this.updateCurrentRule(qncType.getTypeGrammar());
        }
    }

    protected final void handleElementPrefix(QNameContext qnc) throws IOException {
        String pfx;
        if (this.preservePrefix) {
            pfx = this.decodeQNamePrefix(this.getUri(qnc.getNamespaceUriID()), this.channel);
        } else {
            this.checkDefaultPrefixNamespaceDeclaration(qnc);
            pfx = qnc.getDefaultPrefix();
        }
        this.getElementContext().setPrefix(pfx);
    }

    protected final void handleAttributePrefix(QNameContext qnc) throws IOException {
        if (this.preservePrefix) {
            this.attributePrefix = this.decodeQNamePrefix(this.getUri(qnc.getNamespaceUriID()), this.channel);
        } else {
            this.checkDefaultPrefixNamespaceDeclaration(qnc);
            this.attributePrefix = qnc.getDefaultPrefix();
        }
    }

    protected final void checkDefaultPrefixNamespaceDeclaration(QNameContext qnc) {
        assert (!this.preservePrefix);
        if (qnc.getNamespaceUriID() >= this.numberOfUriContexts) {
            String uri = qnc.getNamespaceUri();
            String pfx = this.getPrefix(uri);
            if (pfx == null) {
                pfx = qnc.getDefaultPrefix();
                this.declarePrefix(pfx, uri);
            }
            assert (qnc.getDefaultPrefix().equals(pfx));
        }
    }

    protected final Datatype decodeAttributeStructure() throws EXIException, IOException {
        Attribute at = (Attribute)this.nextEvent;
        this.attributeQNameContext = at.getQNameContext();
        this.handleAttributePrefix(this.attributeQNameContext);
        this.updateCurrentRule(this.nextGrammar);
        return at.getDatatype();
    }

    protected final void decodeAttributeNSStructure() throws EXIException, IOException {
        AttributeNS atNS = (AttributeNS)this.nextEvent;
        AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(atNS.getNamespaceUriID());
        this.attributeQNameContext = this.decodeLocalName(uc, this.channel);
        this.handleAttributePrefix(this.attributeQNameContext);
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeAttributeAnyInvalidValueStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
    }

    protected final void decodeAttributeGenericStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeAttributeGenericUndeclaredStructure() throws EXIException, IOException {
        this.decodeAttributeGenericStructureOnly();
        this.getCurrentGrammar().learnAttribute(new Attribute(this.attributeQNameContext));
    }

    private final void decodeAttributeGenericStructureOnly() throws EXIException, IOException {
        this.attributeQNameContext = this.decodeQName(this.channel);
        this.handleAttributePrefix(this.attributeQNameContext);
    }

    protected final Datatype decodeCharactersStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS);
        this.updateCurrentRule(this.nextGrammar);
        return ((Characters)this.nextEvent).getDatatype();
    }

    protected final void decodeCharactersGenericStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC);
        this.updateCurrentRule(this.nextGrammar);
    }

    protected final void decodeCharactersGenericUndeclaredStructure() throws EXIException {
        assert (this.nextEventType == EventType.CHARACTERS_GENERIC_UNDECLARED);
        Grammar currentGrammar = this.getCurrentGrammar();
        currentGrammar.learnCharacters();
        this.updateCurrentRule(currentGrammar.getElementContentGrammar());
    }

    protected final NamespaceDeclaration decodeNamespaceDeclarationStructure() throws EXIException, IOException {
        AbstractEXIBodyCoder.RuntimeUriContext euc = this.decodeUri(this.channel);
        String nsPrefix = this.decodeNamespacePrefix(euc, this.channel);
        boolean local_element_ns = this.channel.decodeBoolean();
        if (local_element_ns) {
            this.getElementContext().setPrefix(nsPrefix);
        }
        NamespaceDeclaration nsDecl = new NamespaceDeclaration(euc.getNamespaceUri(), nsPrefix);
        this.declarePrefix(nsDecl);
        return nsDecl;
    }

    protected final char[] decodeEntityReferenceStructure() throws EXIException, IOException {
        char[] er = this.channel.decodeString();
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return er;
    }

    protected final char[] decodeCommentStructure() throws EXIException, IOException {
        char[] comment = this.channel.decodeString();
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return comment;
    }

    protected final ProcessingInstruction decodeProcessingInstructionStructure() throws EXIException, IOException {
        String piTarget = new String(this.channel.decodeString());
        String piData = new String(this.channel.decodeString());
        this.updateCurrentRule(this.getCurrentGrammar().getElementContentGrammar());
        return new ProcessingInstruction(piTarget, piData);
    }

    protected final DocType decodeDocTypeStructure() throws EXIException, IOException {
        char[] name = this.channel.decodeString();
        char[] publicID = this.channel.decodeString();
        char[] systemID = this.channel.decodeString();
        char[] text = this.channel.decodeString();
        return new DocType(name, publicID, systemID, text);
    }

    public void decodeStartSelfContainedFragment() throws EXIException, IOException {
        throw new RuntimeException("[EXI] SelfContained");
    }
}

