/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.coder;

import java.io.IOException;
import java.io.OutputStream;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.coder.AbstractEXIBodyEncoder;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.BitEncoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.ByteEncoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.EncoderChannel;

public class EXIBodyEncoderInOrder
extends AbstractEXIBodyEncoder {
    public EXIBodyEncoderInOrder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        CodingMode codingMode = this.exiFactory.getCodingMode();
        if (codingMode == CodingMode.BIT_PACKED) {
            this.setOutputChannel(new BitEncoderChannel(os));
        } else {
            assert (codingMode == CodingMode.BYTE_PACKED);
            this.setOutputChannel(new ByteEncoderChannel(os));
        }
    }

    public void setOutputChannel(EncoderChannel encoderChannel) {
        this.channel = encoderChannel;
    }

    protected void writeValue(QNameContext valueContext) throws IOException {
        this.typeEncoder.writeValue(valueContext, this.channel, this.stringEncoder);
    }
}

