/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.coder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.SchemaIdResolver;
import org.opendaylight.netconf.shaded.exificient.core.coder.AbstractEXIHeader;
import org.opendaylight.netconf.shaded.exificient.core.coder.EXIBodyDecoderInOrder;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.UnsupportedOption;
import org.opendaylight.netconf.shaded.exificient.core.grammars.SchemaLessGrammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.helpers.DefaultEXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.BitDecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.values.BooleanValue;
import org.opendaylight.netconf.shaded.exificient.core.values.DecimalValue;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValue;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValueType;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;
import org.opendaylight.netconf.shaded.exificient.core.values.ValueType;

public class EXIHeaderDecoder
extends AbstractEXIHeader {
    protected QNameContext lastSE;
    protected boolean dtrSection;
    protected List<QName> dtrMapTypes = new ArrayList<QName>();
    protected List<QName> dtrMapRepresentations = new ArrayList<QName>();

    protected void clear() {
        this.lastSE = null;
        this.dtrSection = false;
        this.dtrMapTypes.clear();
        this.dtrMapRepresentations.clear();
    }

    public EXIFactory parse(BitDecoderChannel headerChannel, EXIFactory noOptionsFactory) throws EXIException {
        try {
            int value;
            if (headerChannel.lookAhead() == 36) {
                int h0 = headerChannel.decode();
                int h1 = headerChannel.decode();
                int h2 = headerChannel.decode();
                int h3 = headerChannel.decode();
                if (h0 != 36 || h1 != 69 || h2 != 88 || h3 != 73) {
                    throw new EXIException("No valid EXI Cookie ($EXI)");
                }
            }
            if (headerChannel.decodeNBitUnsignedInteger(2) != 2) {
                throw new EXIException("No valid EXI document according distinguishing bits");
            }
            boolean presenceOptions = headerChannel.decodeBoolean();
            boolean previewVersion = headerChannel.decodeBoolean();
            assert (!previewVersion);
            int version = 0;
            do {
                value = headerChannel.decodeNBitUnsignedInteger(4);
                version += value;
            } while (value == 15);
            assert (version == 0);
            EXIFactory exiFactory = presenceOptions ? this.readEXIOptions(headerChannel, noOptionsFactory) : noOptionsFactory;
            CodingMode codingMode = exiFactory.getCodingMode();
            if (codingMode != CodingMode.BIT_PACKED) {
                headerChannel.align();
            }
            return exiFactory;
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public EXIFactory readEXIOptions(DecoderChannel decoderChannel, EXIFactory noOptionsFactory) throws EXIException, IOException {
        EventType eventType;
        EXIBodyDecoderInOrder decoder = (EXIBodyDecoderInOrder)this.getHeaderFactory().createEXIBodyDecoder();
        decoder.setInputChannel(decoderChannel);
        EXIFactory exiOptionsFactory = DefaultEXIFactory.newInstance();
        exiOptionsFactory.setSchemaIdResolver(noOptionsFactory.getSchemaIdResolver());
        exiOptionsFactory.setDecodingOptions(noOptionsFactory.getDecodingOptions());
        exiOptionsFactory.setGrammars(noOptionsFactory.getGrammars());
        this.clear();
        block11: while ((eventType = decoder.next()) != null) {
            switch (eventType) {
                case START_DOCUMENT: {
                    decoder.decodeStartDocument();
                    continue block11;
                }
                case END_DOCUMENT: {
                    decoder.decodeEndDocument();
                    continue block11;
                }
                case ATTRIBUTE_XSI_NIL: {
                    decoder.decodeAttributeXsiNil();
                    this.handleXsiNil(decoder.getAttributeValue(), exiOptionsFactory);
                    continue block11;
                }
                case ATTRIBUTE_XSI_TYPE: {
                    decoder.decodeAttributeXsiType();
                    continue block11;
                }
                case ATTRIBUTE: 
                case ATTRIBUTE_NS: 
                case ATTRIBUTE_GENERIC: 
                case ATTRIBUTE_GENERIC_UNDECLARED: 
                case ATTRIBUTE_INVALID_VALUE: 
                case ATTRIBUTE_ANY_INVALID_VALUE: {
                    decoder.decodeAttribute();
                    continue block11;
                }
                case NAMESPACE_DECLARATION: {
                    decoder.decodeNamespaceDeclaration();
                    continue block11;
                }
                case START_ELEMENT: 
                case START_ELEMENT_NS: 
                case START_ELEMENT_GENERIC: 
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    this.handleStartElement(decoder.decodeStartElement(), exiOptionsFactory);
                    continue block11;
                }
                case END_ELEMENT: 
                case END_ELEMENT_UNDECLARED: {
                    this.handleEndElement(decoder.decodeEndElement(), exiOptionsFactory);
                    continue block11;
                }
                case CHARACTERS: 
                case CHARACTERS_GENERIC: 
                case CHARACTERS_GENERIC_UNDECLARED: {
                    this.handleCharacters(decoder.decodeCharacters(), exiOptionsFactory);
                    continue block11;
                }
            }
            throw new RuntimeException("Unexpected EXI Event in Header '" + (Object)((Object)eventType) + "' ");
        }
        if (this.dtrMapTypes.size() == this.dtrMapTypes.size() && this.dtrMapTypes.size() > 0) {
            QName[] dtrMapTypesA = new QName[this.dtrMapTypes.size()];
            dtrMapTypesA = this.dtrMapTypes.toArray(dtrMapTypesA);
            QName[] dtrMapRepresentationsA = new QName[this.dtrMapRepresentations.size()];
            dtrMapRepresentationsA = this.dtrMapRepresentations.toArray(dtrMapRepresentationsA);
            exiOptionsFactory.setDatatypeRepresentationMap(dtrMapTypesA, dtrMapRepresentationsA);
        }
        return exiOptionsFactory;
    }

    protected void handleStartElement(QNameContext se, EXIFactory f) throws UnsupportedOption {
        if (this.dtrSection) {
            if (this.dtrMapTypes.size() == this.dtrMapRepresentations.size()) {
                this.dtrMapTypes.add(se.getQName());
            } else {
                this.dtrMapRepresentations.add(se.getQName());
            }
        } else if ("http://www.w3.org/2009/exi".equals(se.getNamespaceUri())) {
            String localName = se.getLocalName();
            if ("byte".equals(localName)) {
                f.setCodingMode(CodingMode.BYTE_PACKED);
            } else if ("pre-compress".equals(localName)) {
                f.setCodingMode(CodingMode.PRE_COMPRESSION);
            } else if ("selfContained".equals(localName)) {
                f.getFidelityOptions().setFidelity("SELF_CONTAINED", true);
            } else if ("datatypeRepresentationMap".equals(localName)) {
                this.dtrSection = true;
            } else if ("dtd".equals(localName)) {
                f.getFidelityOptions().setFidelity("PRESERVE_DTDS", true);
            } else if ("prefixes".equals(localName)) {
                f.getFidelityOptions().setFidelity("PRESERVE_PREFIXES", true);
            } else if ("lexicalValues".equals(localName)) {
                f.getFidelityOptions().setFidelity("PRESERVE_LEXICAL_VALUES", true);
            } else if ("comments".equals(localName)) {
                f.getFidelityOptions().setFidelity("PRESERVE_COMMENTS", true);
            } else if ("pis".equals(localName)) {
                f.getFidelityOptions().setFidelity("PRESERVE_PIS", true);
            } else if ("compression".equals(localName)) {
                f.setCodingMode(CodingMode.COMPRESSION);
            } else if ("fragment".equals(localName)) {
                f.setFragment(true);
            } else if ("strict".equals(localName)) {
                f.getFidelityOptions().setFidelity("STRICT", true);
            } else if ("p".equals(localName)) {
                // empty if block
            }
        }
        this.lastSE = se;
    }

    protected void handleEndElement(QNameContext ee, EXIFactory f) {
        String localName;
        if ("http://www.w3.org/2009/exi".equals(ee.getNamespaceUri()) && "datatypeRepresentationMap".equals(localName = ee.getLocalName())) {
            this.dtrSection = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleCharacters(Value value, EXIFactory f) throws EXIException {
        String localName = this.lastSE.getLocalName();
        if ("valueMaxLength".equals(localName)) {
            if (!(value instanceof IntegerValue)) throw new EXIException("[EXI-Header] Failure while processing " + localName);
            IntegerValue iv = (IntegerValue)value;
            f.setValueMaxLength(iv.intValue());
            return;
        } else if ("valuePartitionCapacity".equals(localName)) {
            if (!(value instanceof IntegerValue)) throw new EXIException("[EXI-Header] Failure while processing " + localName);
            IntegerValue iv = (IntegerValue)value;
            if (iv.getIntegerValueType() != IntegerValueType.INT) throw new EXIException("[EXI-Header] ValuePartitionCapacity other than int not supported: " + iv);
            f.setValuePartitionCapacity(iv.intValue());
            return;
        } else if ("blockSize".equals(localName)) {
            if (!(value instanceof IntegerValue)) throw new EXIException("[EXI-Header] Failure while processing " + localName);
            IntegerValue iv = (IntegerValue)value;
            if (iv.getIntegerValueType() != IntegerValueType.INT) throw new EXIException("[EXI-Header] BlockSize other than int not supported: " + iv);
            f.setBlockSize(iv.intValue());
            return;
        } else if ("schemaId".equals(localName)) {
            if (f.getDecodingOptions().isOptionEnabled("IGNORE_SCHEMA_ID")) return;
            String schemaId = value.toString();
            assert (schemaId != null);
            SchemaIdResolver sir = f.getSchemaIdResolver();
            if (sir == null) throw new EXIException("EXI Header povides schemaId '" + schemaId + "'. No schemaIdResolver set!");
            f.setGrammars(sir.resolveSchemaId(schemaId));
            return;
        } else {
            if (!"p".equals(localName) || value.getValueType() != ValueType.DECIMAL) return;
            DecimalValue dv = (DecimalValue)value;
            f.setLocalValuePartitions(dv.isNegative());
            assert (dv.getIntegral().getIntegerValueType() == IntegerValueType.INT);
            f.setMaximumNumberOfBuiltInElementGrammars(dv.getIntegral().intValue() - 1);
            assert (dv.getRevFractional().getIntegerValueType() == IntegerValueType.INT);
            f.setMaximumNumberOfBuiltInProductions(dv.getRevFractional().intValue() - 1);
        }
    }

    protected void handleXsiNil(Value value, EXIFactory f) throws EXIException {
        String localName = this.lastSE.getLocalName();
        if ("schemaId".equals(localName)) {
            if (value instanceof BooleanValue) {
                BooleanValue bv = (BooleanValue)value;
                if (bv.toBoolean()) {
                    f.setGrammars(new SchemaLessGrammars());
                }
            } else {
                throw new EXIException("[EXI-Header] Failure while processing " + localName);
            }
        }
    }
}

