/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.datatype;

import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.AbstractDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DatatypeID;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltInType;
import org.opendaylight.netconf.shaded.exificient.core.types.DateTimeType;
import org.opendaylight.netconf.shaded.exificient.core.values.DateTimeValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;

public class DatetimeDatatype
extends AbstractDatatype {
    DateTimeType datetimeType;
    private DateTimeValue lastValidDatetime;

    public DatetimeDatatype(DateTimeType dateType, QNameContext schemaType) {
        super(BuiltInType.DATETIME, schemaType);
        this.datetimeType = dateType;
    }

    public DatatypeID getDatatypeID() {
        DatatypeID dtID;
        switch (this.datetimeType) {
            case dateTime: {
                dtID = DatatypeID.exi_dateTime;
                break;
            }
            case time: {
                dtID = DatatypeID.exi_time;
                break;
            }
            case date: {
                dtID = DatatypeID.exi_date;
                break;
            }
            case gYearMonth: {
                dtID = DatatypeID.exi_gYearMonth;
                break;
            }
            case gYear: {
                dtID = DatatypeID.exi_gYear;
                break;
            }
            case gMonthDay: {
                dtID = DatatypeID.exi_gMonthDay;
                break;
            }
            case gDay: {
                dtID = DatatypeID.exi_gDay;
                break;
            }
            case gMonth: {
                dtID = DatatypeID.exi_gMonth;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return dtID;
    }

    public DateTimeType getDatetimeType() {
        return this.datetimeType;
    }

    protected boolean isValidString(String value) {
        this.lastValidDatetime = DateTimeValue.parse(value, this.datetimeType);
        return this.lastValidDatetime != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof DateTimeValue) {
            this.lastValidDatetime = (DateTimeValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof DatetimeDatatype) {
            DatetimeDatatype dt = (DatetimeDatatype)o;
            return this.datetimeType == dt.getDatetimeType();
        }
        return false;
    }
}

