/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.util.xml;

public class XMLWhitespace {
    public static final char WS_SPACE = ' ';
    public static final char WS_NL = '\n';
    public static final char WS_CR = '\r';
    public static final char WS_TAB = '\t';

    public static int getLeadingWhitespaces(char[] ch, int start, int length) {
        int end = start + length;
        int leadingWS = 0;
        while (start < end && XMLWhitespace.isWhiteSpace(ch[start])) {
            ++start;
            ++leadingWS;
        }
        return leadingWS;
    }

    public static int getTrailingWhitespaces(char[] ch, int start, int length) {
        int pos = start + length - 1;
        int trailingWS = 0;
        while (pos >= start && XMLWhitespace.isWhiteSpace(ch[pos])) {
            --pos;
            ++trailingWS;
        }
        return trailingWS;
    }

    public static boolean isWhiteSpaceOnly(char[] ch, int start, int length) {
        if (!XMLWhitespace.isWhiteSpace(ch[start])) {
            return false;
        }
        int end = start + length;
        while (++start < end && XMLWhitespace.isWhiteSpace(ch[start])) {
        }
        return start == end;
    }

    public static boolean isWhiteSpaceOnly(String chars) {
        if (!XMLWhitespace.isWhiteSpace(chars.charAt(0))) {
            return false;
        }
        int end = chars.length();
        int start = 1;
        while (start < end && XMLWhitespace.isWhiteSpace(chars.charAt(start++))) {
        }
        return start == end;
    }

    public static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }
}

