/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.values;

import org.opendaylight.netconf.shaded.exificient.core.values.AbstractBinaryValue;
import org.opendaylight.netconf.shaded.exificient.core.values.ValueType;

public class BinaryBase64Value
extends AbstractBinaryValue {
    private int fewerThan24bits;
    private int numberTriplets;
    private int numberQuartet;
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    public BinaryBase64Value(byte[] bytes) {
        super(ValueType.BINARY_BASE64, bytes);
    }

    public static BinaryBase64Value parse(String val) {
        byte[] bytes = BinaryBase64Value.decode(val);
        if (bytes == null) {
            return null;
        }
        return new BinaryBase64Value(bytes);
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            int lengthDataBits = this.bytes.length * 8;
            if (lengthDataBits == 0) {
                this.slen = 0;
            } else {
                this.fewerThan24bits = lengthDataBits % 24;
                this.numberTriplets = lengthDataBits / 24;
                this.numberQuartet = this.fewerThan24bits != 0 ? this.numberTriplets + 1 : this.numberTriplets;
                this.slen = this.numberQuartet * 4;
            }
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        byte val1;
        this.getCharactersLength();
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        for (int i = 0; i < this.numberTriplets; ++i) {
            b1 = this.bytes[dataIndex++];
            b2 = this.bytes[dataIndex++];
            b3 = this.bytes[dataIndex++];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte val12 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[val12];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[l << 2 | val3];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[b3 & 0x3F];
        }
        if (this.fewerThan24bits == 8) {
            b1 = this.bytes[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[val1];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[k << 4];
            cbuffer[offset + encodedIndex++] = 61;
            cbuffer[offset + encodedIndex++] = 61;
        } else if (this.fewerThan24bits == 16) {
            b1 = this.bytes[dataIndex];
            b2 = this.bytes[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[val1];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
            cbuffer[offset + encodedIndex++] = lookUpBase64Alphabet[l << 2];
            cbuffer[offset + encodedIndex++] = 61;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BinaryBase64Value) {
            return this._equals(((BinaryBase64Value)o).bytes);
        }
        BinaryBase64Value bv = BinaryBase64Value.parse(o.toString());
        return bv == null ? false : this._equals(bv.bytes);
    }

    public int hashCode() {
        int hc = 0;
        for (byte b : this.bytes) {
            hc = hc * 31 ^ b;
        }
        return hc;
    }

    protected static boolean isWhiteSpace(char octect) {
        return octect == ' ' || octect == '\r' || octect == '\n' || octect == '\t';
    }

    protected static boolean isPad(char octect) {
        return octect == '=';
    }

    protected static boolean isData(char octect) {
        return octect < '\u0080' && base64Alphabet[octect] != -1;
    }

    protected static boolean isBase64(char octect) {
        return BinaryBase64Value.isWhiteSpace(octect) || BinaryBase64Value.isPad(octect) || BinaryBase64Value.isData(octect);
    }

    public static byte[] decode(String encoded) {
        int i;
        if (encoded == null) {
            return null;
        }
        char[] base64Data = encoded.toCharArray();
        int len = BinaryBase64Value.removeWhiteSpace(base64Data);
        if (len % 4 != 0) {
            return null;
        }
        int numberQuadruple = len / 4;
        if (numberQuadruple == 0) {
            return new byte[0];
        }
        byte[] decodedData = null;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        char d1 = '\u0000';
        char d2 = '\u0000';
        char d3 = '\u0000';
        char d4 = '\u0000';
        int encodedIndex = 0;
        int dataIndex = 0;
        decodedData = new byte[numberQuadruple * 3];
        for (i = 0; i < numberQuadruple - 1; ++i) {
            if (!(BinaryBase64Value.isData(d1 = base64Data[dataIndex++]) && BinaryBase64Value.isData(d2 = base64Data[dataIndex++]) && BinaryBase64Value.isData(d3 = base64Data[dataIndex++]) && BinaryBase64Value.isData(d4 = base64Data[dataIndex++]))) {
                return null;
            }
            b1 = base64Alphabet[d1];
            b2 = base64Alphabet[d2];
            b3 = base64Alphabet[d3];
            b4 = base64Alphabet[d4];
            decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
            decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
        }
        if (!BinaryBase64Value.isData(d1 = base64Data[dataIndex++]) || !BinaryBase64Value.isData(d2 = base64Data[dataIndex++])) {
            return null;
        }
        b1 = base64Alphabet[d1];
        b2 = base64Alphabet[d2];
        d3 = base64Data[dataIndex++];
        d4 = base64Data[dataIndex++];
        if (!BinaryBase64Value.isData(d3) || !BinaryBase64Value.isData(d4)) {
            if (BinaryBase64Value.isPad(d3) && BinaryBase64Value.isPad(d4)) {
                if ((b2 & 0xF) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 1];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                return tmp;
            }
            if (!BinaryBase64Value.isPad(d3) && BinaryBase64Value.isPad(d4)) {
                b3 = base64Alphabet[d3];
                if ((b3 & 3) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 2];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                tmp[encodedIndex] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                return tmp;
            }
            return null;
        }
        b3 = base64Alphabet[d3];
        b4 = base64Alphabet[d4];
        decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
        decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
        decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
        return decodedData;
    }

    protected static int removeWhiteSpace(char[] data) {
        if (data == null) {
            return 0;
        }
        int newSize = 0;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (BinaryBase64Value.isWhiteSpace(data[i])) continue;
            data[newSize++] = data[i];
        }
        return newSize;
    }

    static {
        int i;
        base64Alphabet = new byte[128];
        lookUpBase64Alphabet = new char[64];
        for (i = 0; i < 128; ++i) {
            BinaryBase64Value.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            BinaryBase64Value.base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            BinaryBase64Value.base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            BinaryBase64Value.base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        BinaryBase64Value.base64Alphabet[43] = 62;
        BinaryBase64Value.base64Alphabet[47] = 63;
        for (i = 0; i <= 25; ++i) {
            BinaryBase64Value.lookUpBase64Alphabet[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            BinaryBase64Value.lookUpBase64Alphabet[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            BinaryBase64Value.lookUpBase64Alphabet[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        BinaryBase64Value.lookUpBase64Alphabet[62] = 43;
        BinaryBase64Value.lookUpBase64Alphabet[63] = 47;
    }
}

