/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.values;

import java.util.StringTokenizer;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.types.TypedTypeEncoder;
import org.opendaylight.netconf.shaded.exificient.core.values.AbstractValue;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;
import org.opendaylight.netconf.shaded.exificient.core.values.ValueType;

public class ListValue
extends AbstractValue {
    protected final Value[] values;
    protected final Datatype listDatatype;
    protected final int numberOfValues;

    public ListValue(Value[] values, Datatype listDatatype) {
        super(ValueType.LIST);
        this.values = values;
        this.numberOfValues = values.length;
        this.listDatatype = listDatatype;
    }

    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    public Value[] toValues() {
        return this.values;
    }

    public Datatype getListDatatype() {
        return this.listDatatype;
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            this.slen = this.values.length > 0 ? this.values.length - 1 : 0;
            int vlen = this.values.length;
            for (int i = 0; i < vlen; ++i) {
                this.slen += this.values[i].getCharactersLength();
            }
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        if (this.values.length > 0) {
            Value iVal;
            int vlenMinus1 = this.values.length - 1;
            for (int i = 0; i < vlenMinus1; ++i) {
                iVal = this.values[i];
                iVal.getCharacters(cbuffer, offset);
                offset += iVal.getCharactersLength();
                cbuffer[offset++] = 32;
            }
            iVal = this.values[vlenMinus1];
            iVal.getCharacters(cbuffer, offset);
        }
    }

    public static ListValue parse(String value, Datatype listDatatype) {
        StringTokenizer st = new StringTokenizer(value);
        Value[] values = new Value[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            StringValue nextToken = new StringValue(st.nextToken());
            try {
                TypedTypeEncoder typeEncoder = new TypedTypeEncoder();
                if (typeEncoder.isValid(listDatatype, nextToken)) {
                    values[index++] = nextToken;
                    continue;
                }
                return null;
            }
            catch (EXIException e) {
                return null;
            }
        }
        return new ListValue(values, listDatatype);
    }

    protected final boolean _equals(ListValue o) {
        if (this.listDatatype.getBuiltInType() != o.listDatatype.getBuiltInType()) {
            return false;
        }
        if (this.values.length == o.values.length) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i].equals(o.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ListValue) {
            return this._equals((ListValue)o);
        }
        ListValue lv = ListValue.parse(o.toString(), this.listDatatype);
        return lv == null ? false : this._equals(lv);
    }

    public int hashCode() {
        int hc = 0;
        for (Value val : this.values) {
            hc = hc * 31 ^ val.hashCode();
        }
        return hc;
    }
}

