/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.values;

import org.opendaylight.netconf.shaded.exificient.core.values.AbstractValue;
import org.opendaylight.netconf.shaded.exificient.core.values.ValueType;

public class QNameValue
extends AbstractValue {
    protected final String namespaceUri;
    protected final String localName;
    protected final String prefix;
    protected char[] characters;
    protected final String sValue;

    public QNameValue(String namespaceUri, String localName, String prefix) {
        super(ValueType.QNAME);
        this.namespaceUri = namespaceUri;
        this.localName = localName;
        this.prefix = prefix;
        this.sValue = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getCharactersLength() {
        return this.sValue.length();
    }

    public char[] getCharacters() {
        if (this.characters == null) {
            int len = this.sValue.length();
            this.characters = new char[len];
            this.sValue.getChars(0, this.sValue.length(), this.characters, 0);
        }
        return this.characters;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        for (int i = 0; i < this.sValue.length(); ++i) {
            cbuffer[i + offset] = this.sValue.charAt(i);
        }
    }

    public String toString() {
        return this.sValue;
    }

    public String toString(char[] cbuffer, int offset) {
        return this.sValue;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof QNameValue) {
            QNameValue other = (QNameValue)o;
            return this.namespaceUri.equals(other.namespaceUri) && this.localName.equals(other.localName);
        }
        return false;
    }

    public int hashCode() {
        return this.namespaceUri.hashCode() ^ this.localName.hashCode();
    }
}

