/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.grammars;

import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class GrammarAnnotationFilter
implements ContentHandler {
    private static final TransformerFactory tf = TransformerFactory.newInstance();
    private ContentHandler ch;
    private boolean rootElement;
    private final AttributesImpl typeNameAtts = new AttributesImpl();

    public GrammarAnnotationFilter(OutputStream os, String typeName) throws SAXException {
        this.typeNameAtts.addAttribute("", "name", "name", "CDATA", typeName);
        try {
            Transformer t = tf.newTransformer();
            t.transform(new SAXSource(new XMLReader(){

                public ContentHandler getContentHandler() {
                    return GrammarAnnotationFilter.this.ch;
                }

                public DTDHandler getDTDHandler() {
                    return null;
                }

                public EntityResolver getEntityResolver() {
                    return null;
                }

                public ErrorHandler getErrorHandler() {
                    return null;
                }

                public boolean getFeature(String name) {
                    return false;
                }

                public Object getProperty(String name) {
                    return null;
                }

                public void parse(InputSource input) {
                }

                public void parse(String systemId) {
                }

                public void setContentHandler(ContentHandler handler) {
                    GrammarAnnotationFilter.this.ch = handler;
                }

                public void setDTDHandler(DTDHandler handler) {
                }

                public void setEntityResolver(EntityResolver resolver) {
                }

                public void setErrorHandler(ErrorHandler handler) {
                }

                public void setFeature(String name, boolean value) {
                }

                public void setProperty(String name, Object value) {
                }
            }, new InputSource()), new StreamResult(os));
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
        if (this.ch == null) {
            throw new SAXException("Transformer didn't set ContentHandler");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.ch.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.ch.startDocument();
        this.rootElement = true;
    }

    public void endDocument() throws SAXException {
        this.ch.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.ch.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.ch.endPrefixMapping(prefix);
    }

    private String fixQName(String qname, String ename) {
        int index = qname.indexOf(58);
        if (index == -1) {
            return ename;
        }
        return qname.substring(0, index + 1) + ename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.rootElement && "http://www.w3.org/2001/XMLSchema".equals(uri) && "annotation".equals(localName)) {
            this.ch.startElement(uri, "schema", this.fixQName(qName, "schema"), null);
        } else {
            if (this.rootElement) {
                throw new SAXException("No annotation element as root element");
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "appinfo".equals(localName)) {
                int indexAt;
                if (atts == null || (indexAt = atts.getIndex("http://www.w3.org/2009/exi", "prepopulateValues")) == -1 || !"true".equals(atts.getValue(indexAt))) throw new SAXException("No prepopulateValues attribute in annotation element");
                this.ch.startElement(uri, "simpleType", this.fixQName(qName, "simpleType"), this.typeNameAtts);
            } else {
                this.ch.startElement(uri, localName, qName, atts);
            }
        }
        this.rootElement = false;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "annotation".equals(localName)) {
            this.ch.endElement(uri, "schema", this.fixQName(qName, "schema"));
        } else if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "appinfo".equals(localName)) {
            this.ch.endElement(uri, "simpleType", this.fixQName(qName, "simpleType"));
        } else {
            this.ch.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.ch.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.ch.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.ch.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.ch.skippedEntity(name);
    }
}

