/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.main.api.dom;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.dom.SaxToDomHandler;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DOMBuilder {
    protected EXIFactory factory;
    protected DOMImplementation domImplementation;

    public DOMBuilder(EXIFactory factory) throws ParserConfigurationException {
        this.factory = factory;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        this.domImplementation = builder.getDOMImplementation();
    }

    public DocumentFragment parseFragment(InputStream is) throws EXIException {
        try {
            SaxToDomHandler s2dHandler = new SaxToDomHandler(this.domImplementation, true);
            XMLReader reader = new SAXFactory(this.factory).createEXIReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setContentHandler(s2dHandler);
            reader.parse(new InputSource(is));
            return s2dHandler.getDocumentFragment();
        }
        catch (Exception e) {
            throw new EXIException(e);
        }
    }

    public Document parse(InputStream is) throws EXIException {
        return this.parse(is, false);
    }

    public Document parse(InputStream is, boolean exiBodyOnly) throws EXIException {
        try {
            SaxToDomHandler s2dHandler = new SaxToDomHandler(this.domImplementation, false);
            XMLReader reader = new SAXFactory(this.factory).createEXIReader();
            reader.setFeature("http://www.w3.org/exi/features/exi-body-only", exiBodyOnly);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", s2dHandler);
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", s2dHandler);
            reader.setContentHandler(s2dHandler);
            reader.setDTDHandler(s2dHandler);
            reader.parse(new InputSource(is));
            return s2dHandler.getDocument();
        }
        catch (Exception e) {
            throw new EXIException(e);
        }
    }
}

