/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.main.helpers;

import org.opendaylight.netconf.shaded.exificient.core.SchemaIdResolver;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.grammars.GrammarFactory;

public class DefaultSchemaIdResolver
implements SchemaIdResolver {
    protected GrammarFactory getGrammarFactory() {
        return GrammarFactory.newInstance();
    }

    @Override
    public Grammars resolveSchemaId(String schemaId) throws EXIException {
        if (schemaId == null) {
            return this.getGrammarFactory().createSchemaLessGrammars();
        }
        if ("".equals(schemaId)) {
            return this.getGrammarFactory().createXSDTypesOnlyGrammars();
        }
        try {
            return this.getGrammarFactory().createGrammars(schemaId);
        }
        catch (Exception e) {
            throw new EXIException(this.getClass().getName() + " failed to retrieve schemaId == " + schemaId, e);
        }
    }
}

