/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.xerces.impl.xs;

import java.util.AbstractList;
import org.opendaylight.netconf.shaded.xerces.xs.StringList;

final class PSVIErrorList
extends AbstractList
implements StringList {
    private final String[] fArray;
    private final int fLength;
    private final int fOffset;

    public PSVIErrorList(String[] stringArray, boolean bl) {
        this.fArray = stringArray;
        this.fLength = this.fArray.length >> 1;
        this.fOffset = bl ? 0 : 1;
    }

    public boolean contains(String string) {
        if (string == null) {
            int n = 0;
            while (n < this.fLength) {
                if (this.fArray[(n << 1) + this.fOffset] == null) {
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fLength) {
                if (string.equals(this.fArray[(n << 1) + this.fOffset])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int getLength() {
        return this.fLength;
    }

    public String item(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fArray[(n << 1) + this.fOffset];
    }

    public Object get(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fArray[(n << 1) + this.fOffset];
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    public int size() {
        return this.getLength();
    }
}

